<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th style="background-color: #007D88; font-weight: bold;">Ngày</th>
                <th style="background-color: #007D88; font-weight: bold;">ID Bill</th>
                <th style="background-color: #007D88; font-weight: bold;">Sale Name</th>
                <th style="background-color: #007D88; font-weight: bold;">Hạn mức</th>
                <th style="background-color: #007D88; font-weight: bold;">Nợ hiện tại</th>
                <th style="background-color: #007D88; font-weight: bold;">Cước gốc</th>
                <th style="background-color: #007D88; font-weight: bold;">Thu khách</th>
                <th style="background-color: #007D88; font-weight: bold;">Dịch vụ</th>
                <th style="background-color: #007D88; font-weight: bold;">Thanh toán</th>
                <th style="background-color: #007D88; font-weight: bold;">Quốc gia</th> <!-- Fixed: removed duplicate class -->
                <th style="background-color: #007D88; font-weight: bold;">Chi nhánh</th>
                <th style="background-color: #007D88; font-weight: bold;">Người nhận</th>
                <th style="background-color: #007D88; font-weight: bold;">Xác thực</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data_excel as $shipment)
                <tr>
                    <td>{{ formatDate($shipment['created_at']) }}</td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="{{ route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']]) }}">
                            {{ $shipment['shipment_code'] }}
                        </a>
                    </td>
                    <td>[{{ $shipment['user_code'] }}] {{ $shipment['user_contact_name'] }} </td>
                    <td>
                        @if ($shipment['limit_amount_flg'] == NO_LIMIT)
                            Không giới hạn
                        @else
                            {{ $shipment['user_limit_amount_for_sale'] ?? 0 }}
                        @endif
                    </td>
                    <td>{{ $shipment['user_remaining_limit'] }}</td>
                    <td>{{ $shipment['branch_name'] }}</td>
                    <td>{{ number_format($shipment['shipment_amount_original']) }}</td>
                    <td>{{ number_format($shipment['shipment_amount_total_customer']) }}</td>
                    <td>{{ $shipment['service_name'] }}</td>
                    <td>
                        <span
                            class="fw-bold text-{{ $shipment['shipment_payment_status'] == 0 ? 'danger' : 'success' }}">
                            {{ $shipment['shipment_payment_status'] == 0 ? 'Chưa thanh toán' : 'Đã thanh toán' }}
                        </span>
                    </td>
                    <td>
                        {{ $shipment['country_name'] }}
                    </td>
                    <td>{{ $shipment['receiver_contact_name'] }}</td>
                    <td>
                        @if ($shipment['accountant_status'] == 0)
                            <span class="dtr-data fw-bold text-secondary">
                                Đang chờ xác nhận
                            </span>
                        @elseif($shipment['accountant_status'] == 1)
                            <span class="dtr-data fw-bold text-success">
                                Đã xác nhận
                            </span>
                        @else
                            <span class="dtr-data fw-bold text-danger">
                                Đã hủy đơn
                            </span>
                            <p><strong>Nguyên nhân hủy: </strong>{{ $shipment['accountant_cancel_note'] }}</p>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>