<div class="card">
    <div class="card-body">
        <div class="row">
            @foreach ($services as $service)
                <div class="col-xl-4 col-md-6 col-12 mb-3">
                    <div class="card card-dropify-logo-service">
                        <div class="card-header">
                            <h6>{{ $service['service_name'] }}</h6>
                            <div class="d-flex">
                                <span class="badge badge-info">{{ $service['promotion_name'] }}</span>
                            </div>
                        </div>
                        <div class="card-body">
                            <p class="card-text form-logo-service" data-service_id="{{ $service['service_id'] }}">
                                <input type="file" class="dropify dropify-logo-service" accept="image/*"
                                    {!! isset($service['logoService']['logo'])
                                        ? 'data-default-file="' . asset($service['logoService']['logo']) . '"'
                                        : '' !!} />
                                <input type="text" class="form-control mb-2 mt-3 logo-service-title"
                                    value="{{ $service['logoService']['title'] ?? '' }}">
                                <input type="text" class="form-control logo-service-description"
                                    value="{{ $service['logoService']['description'] ?? '' }}">
                            </p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>

<script>
    onLoadSetups();

    function onLoadDropify() {
        $('.dropify-logo-service').dropify({
            messages: {
                'default': 'Kéo và thả hoặc nhấp để tải lên hình ảnh của bạn',
                'replace': 'Kéo và thả hoặc nhấp để thay thế',
                'remove': 'Xóa',
                'error': 'Rất tiếc, đã xảy ra lỗi.'
            },
            tpl: {
                message: 'default',
            }
        });
    }

    async function onLoadSetups() {
        await onLoadDropify();
        $('.card-dropify-logo-service').each(function() {
            let service_id = $(this).find('.dropify-logo-service').data('service_id');
            $(this).find('.dropify-clear').attr('data-service_id', service_id);
        });
    }
</script>
