@php
    $route_name = Route::currentRouteName();
    $route_name_replace = str_replace('.', '_', $route_name);
    $position_id = auth()->user()->position_id;
    $menus = \App\Models\MenuByPosition::isPosition($position_id)->get()->toArray();

    $count_recharge_pennding = \App\Models\Recharge::isShow()
        ->where('status', 0)
        ->select(DB::raw('COUNT(*) as count'))
        ->first();
@endphp
<div class="hk-menu">
    <!-- Brand -->
    <div class="menu-header">
        <span>
            <a class="navbar-brand" href="{{ route('notifications.show') }}">
                <img class="brand-img img-fluid mt-3" width="170px" src="{{ asset(LOGO) }}" alt="brand" />
            </a>

            <button class="btn btn-icon btn-rounded btn-flush-dark flush-soft-hover navbar-toggle">
                <span class="icon">
                    <span class="svg-icon fs-5">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-bar-to-left"
                            width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <line x1="10" y1="12" x2="20" y2="12"></line>
                            <line x1="10" y1="12" x2="14" y2="16"></line>
                            <line x1="10" y1="12" x2="14" y2="8"></line>
                            <line x1="4" y1="4" x2="4" y2="20"></line>
                        </svg>
                    </span>
                </span>
            </button>
        </span>
    </div>
    <!-- /Brand -->

    <!-- Main Menu -->
    <div data-simplebar class="nicescroll-bar">
        <div class="menu-content-wrap pt-1">
            @foreach (config('constans.menus') as $item)
                @php
                    $array_1 = array_column($item['menus'], 'primary');
                    $menus_filtered = array_filter($menus, function ($item) use ($array_1) {
                        return in_array($item['menu_key'], $array_1);
                    });
                @endphp

                @if (!empty($menus_filtered))
                    <div class="menu-group">
                        <div class="nav-header">
                            <span>{{ $item['title'] }}</span>
                        </div>
                        <ul class="navbar-nav flex-column">
                            @foreach ($item['menus'] as $menu)
                                @php
                                    $check_menu = collect($menus)->firstWhere('menu_key', $menu['primary']);
                                @endphp
                                @if (isset($check_menu))
                                    <li
                                        class="nav-item {{ strpos($menu['route'], $route_name) === false ? '' : 'active' }}">
                                        @if (isset($menu['children']))
                                            <a class="nav-link collapsed"
                                                href="{{ isset($menu['route']) ? route($menu['route']) : '' }}"
                                                data-bs-toggle="collapse" data-bs-target="#{{ $menu['primary'] }}"
                                                aria-expanded="{{ strpos($menu['route'], $route_name) === false ? false : true }}">
                                            @else
                                                <a class="nav-link collapsed"
                                                    href="{{ isset($menu['route']) ? route($menu['route']) : '' }}">
                                        @endif

                                        <span class="nav-icon-wrap">
                                            <span class="svg-icon">
                                                {!! $menu['icon'] !!}
                                            </span>
                                        </span>
                                        <span class="nav-link-text">{{ $menu['title'] }}</span>
                                        @if (isset($menu['tag']))
                                            <span
                                                class="badge badge-sm badge-soft-pink ms-auto">{{ $menu['tag'] }}</span>
                                        @endif
                                        @php
                                            if ($menu['primary'] == 'manager_recharge') {
                                                $menu['dot'] = $count_recharge_pennding['count'];
                                            } elseif ($menu['primary'] == 'ticket') {
                                                $menu['dot'] = \App\Models\Ticket::whereIn('ticket_status', [
                                                    TICKET_STATUS_PENDING,
                                                    TICKET_STATUS_PROCESSING,
                                                ])
                                                    ->select(DB::raw('COUNT(*) as count'))
                                                    ->first()['count'];
                                            }
                                        @endphp
                                        @if (isset($menu['dot']) && (int) $menu['dot'] > 0)
                                            <span class="ms-3 badge badge-danger badge-pill">
                                                {{ $menu['dot'] > 9 ? '9+' : $menu['dot'] }}
                                            </span>
                                        @endif
                                        </a>
                                        @if (isset($menu['children']))
                                            <ul id="{{ $menu['primary'] }}"
                                                class="nav flex-column collapse nav-children show">
                                                <li class="nav-item">
                                                    <ul class="nav flex-column">
                                                        @foreach ($menu['children'] as $item)
                                                            @if (
                                                                !(
                                                                    $item['primary'] == 'quan_ly_fwd_sm' &&
                                                                    onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id'])
                                                                ))
                                                                <li
                                                                    class="nav-item {{ $route_name == $item['route'] ? 'active' : '' }}">
                                                                    <a class="nav-link"
                                                                        href="{{ route($item['route']) }}"><span
                                                                            class="nav-link-text">{{ $item['title'] }}</span></a>
                                                                </li>
                                                            @endif
                                                        @endforeach
                                                    </ul>
                                                </li>
                                            </ul>
                                        @endif
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                    </div>
                    <div class="menu-gap"></div>
                @endif
            @endforeach
            <div class="callout card card-flush bg-orange-light-5 text-center mt-5 w-220p mx-auto">
                <div class="card-body">
                    <h5 class="h5">{{ auth()->user()->user_contact_name }}</h5>
                    <p class="p-sm card-text">{{ auth()->user()->user_name }}</p>
                    <a href="{{ route('logout.handle') }}" class="btn btn-primary btn-block">Đăng xuất</a>
                </div>
            </div>
        </div>
    </div>
    <!-- /Main Menu -->
</div>
<div id="hk_menu_backdrop" class="hk-menu-backdrop"></div>
