@php
    $is_show_modal = session()->has('is_show_modal_' . auth()->id())
        ? session()->get('is_show_modal_' . auth()->id())
        : false;
    $modal_notifications = [];
    $modal_notification_ids = [];
    if ($is_show_modal) {
        $modal_notifications = \App\Models\Notification::isActive(ACTIVE)
            ->isDelete(NO_DELETE)
            ->where('notification_important', NOTIFICATION_IMPORTANT)
            ->orderBy('created_at', 'desc')
            ->select('notification_id', 'notification_title', 'notification_content', 'created_at')
            ->get()
            ->toArray();
        $modal_notification_ids = collect($modal_notifications)->pluck('notification_id')->toArray();
    }
@endphp
@if ($is_show_modal)
    @foreach ($modal_notifications as $modal_notification)
        <div class="modal fade" id="exampleModalNotification{{ $modal_notification['notification_id'] }}" tabindex="-1"
            aria-labelledby="exampleModalLabel{{ $modal_notification['notification_id'] }}" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="exampleModalLabel{{ $modal_notification['notification_id'] }}">
                            {{ $modal_notification['notification_title'] }}
                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body ck-content">
                        {!! $modal_notification['notification_content'] !!}
                    </div>
                    <div class="modal-footer d-flex justify-content-start">
                        {{ formatFullDate($modal_notification['created_at']) }}
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@endif
@push('scripts')
    <script>
        var modal_notification_ids = @json($modal_notification_ids);
    </script>
    <script src="{{ asset('js/layouts/notifications.js') }}"></script>
@endpush
