@php
    $path = 'public/config/setting-recharge.json';
    $recharge_settings = json_decode(Storage::get($path), true);
@endphp
<nav class="hk-navbar navbar navbar-expand-xl navbar-light fixed-top">
    <div class="container-fluid">
        <!-- Start Nav -->
        <div class="nav-start-wrap">
            <button class="btn btn-icon btn-rounded btn-flush-dark flush-soft-hover navbar-toggle d-xl-none"><span
                    class="icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span></button>
            <!-- Search -->

            <button class="btn  btn-custom  btn-primary btn-rounded btn-sm" data-bs-toggle="modal"
                data-bs-target="#fullscreenSearchModal"><span><span>Tìm kiếm Tracking</span> <span class="icon"><i
                            class="fas fa-search"></i> </span></span></button>
            <div class="dropdown navbar-search">
                <div class="dropdown-menu p-0" style="height: auto !important;">
                    <!-- Mobile Search -->
                    <div class="dropdown-item d-xl-none bg-transparent">
                        <div class="input-group mobile-search">
                            <span class="input-affix-wrapper input-search">
                                <form class="w-100" action="{{ URL_TRACKING }}" method="GET" target="_blank">
                                    <input type="text" class="form-control" placeholder="Nhập mã tracking..."
                                        aria-label="Nhập mã tracking..." name="code">
                                </form>
                                <span class="input-suffix">
                                    <span class="btn-input-clear"><i class="bi bi-x-circle-fill"></i></span>
                                    <span class="spinner-border spinner-border-sm input-loader text-primary"
                                        role="status">
                                        <span class="sr-only">Loading...</span>
                                    </span>
                                </span>
                            </span>
                        </div>
                    </div>
                    <!--/ Mobile Search -->

                </div>
                <button class="btn btn-primary d-none" type="submit"><i class="fas fa-search"></i></button>
            </div>
            <!-- /Search -->

            <!-- /Search -->
        </div>
        <!-- /Start Nav -->
        <!-- End Nav -->
        <div class="nav-end-wrap">
            <ul class="navbar-nav flex-row">
                <li class="nav-item d-none d-lg-block">
                    <span id="amount_wallet_user" class="ms-1 badge badge-danger fw-bold">Số dư: </span>
                    <a class=" badge badge-success" data-bs-toggle="modal" data-bs-target="#rechargeInpModal">
                        Nạp
                        tiền</a>
                </li>
                <li class="nav-item">
                    <div class="dropdown ps-2">
                        <a class=" dropdown-toggle no-caret" href="" role="button" data-bs-display="static"
                            data-bs-toggle="dropdown" data-dropdown-animation data-bs-auto-close="outside"
                            aria-expanded="false">
                            <div class="avatar avatar-xs  avatar-primary avatar-rounded">
                                @if (empty(auth()->user()['user_logo']))
                                    <span
                                        class="initial-wrap">{{ customTextAvatar(auth()->user()['user_contact_name']) }}</span>
                                @else
                                    <img src="{{ asset(auth()->user()['user_logo']) }}" alt=""
                                        class="avatar-img">
                                @endif
                            </div>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end" style="width: 300px">
                            <div class="p-2">
                                <div class="media">
                                    <div class="media-head me-2">
                                        <div class="avatar avatar-primary avatar-sm avatar-rounded">
                                            @if (empty(auth()->user()['user_logo']))
                                                <span
                                                    class="initial-wrap">{{ customTextAvatar(auth()->user()['user_contact_name']) }}</span>
                                            @else
                                                <img src="{{ asset(auth()->user()['user_logo']) }}" alt=""
                                                    class="avatar-img">
                                            @endif
                                        </div>
                                    </div>
                                    <div class="media-body">
                                        <div class="dropdown">
                                            <a href="#" class="d-block link-dark fw-medium">
                                                {{ auth()->user()['user_contact_name'] }}
                                            </a>
                                        </div>
                                        <div class="fs-7">{{ auth()->user()['user_name'] }}</div>
                                        <a href="{{ route('logout.handle') }}"
                                            class="d-block fs-8 link-secondary"><u>Đăng xuất</u></a>
                                    </div>
                                </div>
                            </div>
                            <div class="dropdown-divider"></div>
                            <div class="card">
                                <div class="dropdown  mb-0">
                                    <div class="p-2">
                                        <div class="fs-7">
                                            <span class="dropdown-icon feather-icon text-primary fs-6">
                                                <i data-feather="credit-card"></i>
                                            </span>
                                            <span>
                                                Hạn mức nợ:
                                                {{ auth()->user()['position']['limit_amount_flg'] == NO_LIMIT ? ' ∞' : formatNumber(auth()->user()['user_limit_amount_for_sale'] . 'đ') }}
                                            </span>
                                        </div>
                                        <div class="fs-7 text-danger">
                                            <span class="dropdown-icon feather-icon fs-6">
                                                <i data-feather="credit-card"></i>
                                            </span>
                                            <span>
                                                Nợ tạm tính:
                                                {{ formatNumber(auth()->user()['user_remaining_limit']) }} vnd
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="dropdown-divider"></div>
                            <h6 class="dropdown-header">Quản lý tài khoản</h6>

                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#rechargeInpModal">
                                <span class="dropdown-icon feather-icon">
                                    <i data-feather="credit-card"></i>
                                </span>
                                <span>Nạp tiền</span>
                            </a>
                            <a class="dropdown-item" href="{{ route('profile.show') }}">
                                <span class="dropdown-icon feather-icon">
                                    <i data-feather="user"></i>
                                </span>
                                <span>Thông tin tài khoản</span>
                            </a>
                            {{-- <a class="dropdown-item" href="#">
                                <span class="dropdown-icon feather-icon">
                                    <i data-feather="credit-card"></i>
                                </span>
                                <span>Ví của tôi</span>
                            </a> --}}
                        </div>
                    </div>
                </li>
            </ul>
        </div>
        <!-- /End Nav -->
    </div>
</nav>

<div class="modal fade" id="rechargeInpModal" tabindex="-1" aria-labelledby="rechargeInpModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h1 class="modal-title text-white fs-5" id="rechargeInpModalLabel">Nạp tiền</h1>
                <button type="button" class="btn-close text-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body">

                <div class="row">
                    <div class="col-sm-6 align-items-stretch">
                        <div class="mb-3">
                            <label for="" class="control-label">Số tiền nạp</label>
                            <input type="text" class="form-control text-number" id="amount_recharge"
                                placeholder="Nhập số tiền bạn đã chuyển khoản">
                            <div id="amount_recharge_err" class="invalid-feedback"></div>
                        </div>
                        <div class="mb-3">
                            <label for="" class="control-label">Ghi chú</label>
                            <textarea class="form-control" id="note_recharge" rows="3"></textarea>
                            <div id="note_recharge_err" class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="col-sm-6 align-items-stretch">
                        <label for="" class="control-label">Bằng chứng</label>
                        <div class="dropzone" id="myDropzone" style="height: 80%;"></div>
                        <div id="image_recharge_err" class="invalid-feedback"></div>
                    </div>
                    <div class="">
                        @foreach ($recharge_settings as $key => $recharge_setting)
                            <div class="btn btn-flush-dark btn-animated">
                                <input class="form-check-input" type="radio" value="{{ $recharge_setting['id'] }}"
                                    name="pay_kind" id="pay_{{ $recharge_setting['key'] }}"
                                    {{ $key == 'vnpay' ? 'checked' : '' }}>
                                <label class="form-check-label" for="pay_{{ $recharge_setting['key'] }}"
                                    onclick="showNote('{{ $recharge_setting['key'] }}')">
                                    {{ $recharge_setting['title'] }}
                                </label>
                            </div>
                        @endforeach

                        <div class="p-3">
                            <div class="w-100 ck-content" id="content-payment"></div>
                            {{-- <div class="w-100 d-none" id="pay_usdt_note">{!! isset(getRechargeSetting()['usdt']['content']) ? getRechargeSetting()['usdt']['content'] : '1' !!}</div>
                            <div class="w-100 d-block" id="pay_direct_note">{!! isset(getRechargeSetting()['direct']['content']) ? getRechargeSetting()['vnpay']['content'] : '2' !!}</div>
                            <div class="w-100 d-block" id="pay_vnpay_note">{!! isset(getRechargeSetting()['vnpay']['content']) ? getRechargeSetting()['vnpay']['content'] : '2' !!}</div> --}}
                        </div>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                    <button type="button" class="btn btn-primary" onclick="onCreateRecharge()">Xác
                        nhận</button>
                </div>

            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="walletModal" tabindex="-1" aria-labelledby="walletModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h1 class="modal-title text-white fs-5" id="walletModalLabel">Ví tiền của tôi</h1>
                <button type="button" class="btn-close text-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            {{-- <div class="modal-body">
                <div class="row">
                    <div class="col-sm-5 align-items-stretch">
                        <div class="mb-3">
                            <div class="card card-body bg-gray-light-4 shadow-xl shadow-hover-sm">
                                <h5>Số dư</h5>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="" class="control-label">Ghi chú</label>
                            <textarea class="form-control" id="note_recharge" rows="3"></textarea>
                            <div id="note_recharge_err" class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="col-sm-7 align-items-stretch">
                        <label for="" class="control-label">Bằng chứng</label>
                        <div class="dropzone" id="myDropzone" style="height: 80%"></div>
                        <div id="image_recharge_err" class="invalid-feedback"></div>
                    </div>
                </div>
            </div> --}}
        </div>
    </div>
</div>

<script></script>
