<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>{{ $meta['title'] ?? 'Kango' }}</title>

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="keywords" content="{{ isset($meta['keywords']) ? $meta['keywords'] : '' }}">
    <meta name="description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}">
    <meta property="og:title" content="{{ isset($meta['title']) ? $meta['title'] : '' }}" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="{{ isset($meta['url']) ? $meta['url'] : '' }}" />
    <meta property="og:image" content="{{ isset($meta['image']) ? $meta['image'] : '' }}" />
    <meta property="og:description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}" />
    <meta property="og:site_name" content="{{ isset($meta['site_name']) ? $meta['site_name'] : '' }}" />

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
    <link rel="icon" href="{{ asset('assets/images/favicon.ico') }}" type="image/x-icon">

    <!-- Sweetalert2 CSS -->




    <!-- boxicons CSS -->
    <link href="{{ asset('assets/boxicons/css/boxicons.min.css') }}" rel="stylesheet" type="text/css">

    <!-- Daterangepicker CSS -->
    <link href="{{ asset('assets/vendors/daterangepicker/daterangepicker.css') }}" rel="stylesheet" type="text/css" />

    <!-- Data Table CSS -->
    <link href="{{ asset('assets/vendors/datatables.net-bs5/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('assets/vendors/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css') }}"
        rel="stylesheet" type="text/css" />

    <!-- CSS -->
    <link href="{{ asset('assets/dist/css/style.css') }}" rel="stylesheet" type="text/css">


    <link href="{{ asset('assets/vendors/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/vendors/sweetalert2/dist/sweetalert2.min.css') }}" rel="stylesheet" type="text/css">

    <!-- drop zone -->
    <link href="{{ asset('assets/vendors/dropzone/dist/dropzone.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ asset('assets/css/content-styles.css') }}" rel="stylesheet" type="text/css" />
</head>

<body>
    @include('template.preload')
    @if (session('success'))
        <div id="message_session_success" class="alert alert-success d-none">
            {{ session('success') }}
        </div>
    @endif
    @if (session('error'))
        <div id="message_session_error" class="alert alert-success d-none">
            {{ session('error') }}
        </div>
    @endif
    @if (auth()->check())
        <div class="hk-wrapper" data-layout="vertical" data-layout-style="default" data-menu="light"
            data-footer="simple">
            <!-- Top Navbar -->
            @include('layouts.navbar')
            <!-- /Top Navbar -->

            <!-- Vertical Nav -->
            @include('layouts.sidebar')
            <!-- /Vertical Nav -->

            @php
                try {
                    $path = 'public/config/system-settings.json';
                    $position_ids = collect(json_decode(Storage::get($path), true))->firstWhere(
                        'kind',
                        SETTING_ACCOUNT_TICKET,
                    )['position_ids'];
                    $is_use_ticket = in_array(
                        auth()->user()['position_id'],
                        isset($position_ids) && $position_ids != '' ? $position_ids : [],
                    );
                    if ($is_use_ticket) {
                        $tiket_kinds = config('constans.constans.tiket_kinds');
                    }
                } catch (\Throwable $th) {
                    $is_use_ticket = false;
                }
            @endphp
            @if ($is_use_ticket)
                @include('supports.tickets.me.popup')
            @endif

            <!-- Main Content -->
            @yield('content')
            <!-- /Main Content -->

            @include('components.button-contact')
            @include('layouts.notifications')

            <!-- Fullscreen Search Modal -->
            <div class="modal fade" id="fullscreenSearchModal" tabindex="-1" aria-labelledby="fullscreenSearchLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-fullscreen">
                    <div class="modal-content fullscreen-search">
                        <div class="modal-header " style="background-color: #21235B">
                            <div class="d-flex justify-content-between align-items-center w-100">
                                <div class="">
                                    <img class="brand-img img-fluid mt-3" width="170px" src="{{ asset(LOGO) }}"
                                        alt="brand" />
                                </div>
                                <div class=""><button type="button" class="btn btn-danger"
                                        data-bs-dismiss="modal" aria-label="Close"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="modal-body d-flex flex-column justify-content-center align-items-center bg-cover"
                            style="background-image: url('{{ asset('assets/images/bg-search.jpg') }}');">
                            <div class="w-100 text-center">
                                <h1>KSN POST</h1>
                                <h5>Track your shipment</h5>
                            </div>
                            <form class="w-50" action="{{ URL_TRACKING }}" method="GET" target="_blank">
                                <div class="input-group">
                                    <input type="search" class="form-control form-control-lg"
                                        placeholder="Input Your Tracking Number" name="code">
                                    <button class="btn btn-lg btn-primary" type="submit">TRACK</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        @yield('content')
    @endif

    <div id="toast-container" class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 1100;"></div>
    <script src="{{ asset('js/utils.js') }}"></script>
    <!-- jQuery -->
    <script src="{{ asset('assets/vendors/jquery/dist/jquery.min.js') }}"></script>

    <!-- Bootstrap Core JS -->
    <script src="{{ asset('assets/vendors/bootstrap/dist/js/bootstrap.bundle.min.js') }}"></script>

    <!-- FeatherIcons JS -->
    <script src="{{ asset('assets/dist/js/feather.min.js') }}"></script>

    <!-- Fancy Dropdown JS -->
    <script src="{{ asset('assets/dist/js/dropdown-bootstrap-extended.js') }}"></script>

    <!-- Simplebar JS -->
    <script src="{{ asset('assets/vendors/simplebar/dist/simplebar.min.js') }}"></script>



    <!-- Daterangepicker JS -->
    <script src="{{ asset('assets/vendors/moment/min/moment.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/dist/js/daterangepicker-data.js') }}"></script>

    <!-- Sweetalert2 JS -->
    {{-- <script src=""></script> --}}
    <script src="{{ asset('assets/vendors/sweetalert2/dist/sweetalert2.min.js') }}"></script>

    <script src="{{ asset('assets/vendors/select2/dist/js/select2.full.min.js') }}"></script>

    <!-- Apex JS -->

    <!-- Init JS -->
    <script src="{{ asset('assets/dist/js/init.js') }}"></script>


    <!-- dropzone 5 -->
    <script src="{{ asset('assets/vendors/dropzone/dist/dropzone.min.js') }}"></script>
    <script>
        Dropzone.autoDiscover = false;
    </script>
    @include('components.loading.modal-loading')


    <script src="{{ asset('js/icons.js') }}"></script>
    <script src="{{ asset('js/sweetalert2.js') }}"></script>
    <script src="{{ asset('js/ajax-contants.js') }}"></script>

    <script src="{{ asset('js/other.js') }}"></script>
    @if (auth()->check())
        <script>
            getWalletUser();
        </script>
    @endif

    @stack('scripts')
</body>

</html>
