@extends('layouts.app')
@section('content')
    @push('scripts')
        <script src="{{ asset('assets/js/xlsx.full.min.js') }}"></script>
        <script>
            async function exportToExcel(data_excel, fileName) {
                var ws = XLSX.utils.json_to_sheet(data_excel);
                var wb = XLSX.utils.book_new();
                await XLSX.utils.book_append_sheet(wb, ws, "Sheet1");
                await XLSX.writeFile(wb, fileName + ".xlsx");

                setTimeout(() => {
                    localStorage.clear();
                    window.close();
                }, 4000);
            }
            var data = null;
            var form_excel = [];
            var headings = {};
            if (localStorage.getItem("data")) {
                data = JSON.parse(localStorage.getItem("data"));
                if (localStorage.getItem('kind') == 1) {
                    headings['Địa chỉ'] = "";
                    $.each(data['weight_range'], function(key, value) {
                        headings[`${value['child_price_list_from_weight']}-${value['child_price_list_to_weight']}`] = "";
                    });
                    $.each(data['weight_range'][0]['cities'], function(key_i, i) {
                        let headings_tmp = JSON.stringify(headings);
                        form_excel[key_i] = JSON.parse(headings_tmp);
                    });
                    $.each(data['weight_range'], function(key_i, i) {
                        $.each(form_excel, function(key_j, j) {
                            form_excel[key_j][`Địa chỉ`] = `${data['weight_range'][0]['cities'][key_j]['city_id']}|${data['weight_range'][0]['cities'][key_j]['city_name']}`;
                            form_excel[key_j][`${i['child_price_list_from_weight']}-${i['child_price_list_to_weight']}`] = `${i['cities'][key_j]['item_child_price_list_amount']}`;
                        });
                    });
                }
                if (localStorage.getItem('kind') == 0) {
                    headings['Mức kg'] = "";
                    $.each(data['weight_range'], function(key, value) {
                        headings[`${value['title']}`] = "";
                    });
                    $.each(data['weight_range'][0]['data'], function(key_i, i) {
                        let headings_tmp = JSON.stringify(headings);
                        form_excel[key_i] = JSON.parse(headings_tmp);
                    });
                    $.each(data['weight_range'], function(key_i, i) {
                        $.each(form_excel, function(key_j, j) {
                            if (data['weight_range'][0]['data'][key_j]['weight_range_flg'] == 0) {
                                form_excel[key_j][`Mức kg`] = `${data['weight_range'][0]['data'][key_j]['child_price_list_to_weight']}`;
                            }
                            if (data['weight_range'][0]['data'][key_j]['weight_range_flg'] == 1) {
                                form_excel[key_j][`Mức kg`] = `${data['weight_range'][0]['data'][key_j]['child_price_list_from_weight']}-${data['weight_range'][0]['data'][key_j]['child_price_list_to_weight']}`;
                            }
                            if (data['weight_range'][0]['data'][key_j]['weight_range_flg'] == 2) {
                                form_excel[key_j][`Mức kg`] = `>${data['weight_range'][0]['data'][key_j]['child_price_list_to_weight']}`;
                            }
                            if (data['weight_range'][0]['data'][key_j]['weight_range_flg'] == 3) {
                                form_excel[key_j][`Mức kg`] = `>=${data['weight_range'][0]['data'][key_j]['child_price_list_to_weight']}`;
                            }
                            form_excel[key_j][`${i['title']}`] = `${i['data'][key_j]['item_child_price_list_amount']}`;
                        });
                    });
                }
                let fileName = `Mẫu import excel bảng giá ${localStorage.getItem('kind') == 1 ? 'vận chuyển' : 'dịch vụ'}[${localStorage.getItem('sub_child_price_list_title')}]`;
                exportToExcel(form_excel, fileName);
            }else{
                alert('Không tồn tại dữ liệu');
            }
        </script>
    @endpush
@endsection
