@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <nav class="contactapp-sidebar">
                    <div data-simplebar class="nicescroll-bar">
                        <div class="menu-content-wrap">

                            <div class="mb-3">
                                <div class="text-center">
                                    <a href="https://kango-post.com/view/labelau/label-kango-au.zip">CSV IMPORT SAMPLE</a>
                                </div>
                                <form action="#" class="dropzone" id="remove_link">
                                    <div class="fallback">
                                        <input name="file" type="file" />
                                    </div>
                                </form>
                                <div class="text-center">
                                    <a class="text-primary" type="button" data-bs-toggle="modal"
                                        data-bs-target="#labelModal">
                                        Label AUPOSTE
                                    </a>
                                </div>
                                <div class="text-center my-3">
                                    <button class="btn btn-custom btn-primary icon-wthot-bg btn-rounded btn-sm">
                                        <span>
                                            <span>Create Label AU</span>
                                            <span class="icon"><i class="fas fa-plus"></i></span>
                                        </span>
                                    </button>
                                </div>
                                <div class="text-center">
                                    <a class="text-primary" type="button" data-bs-toggle="modal"
                                        data-bs-target="#sendModal"><i class="fas fa-share"></i> Send Manifests</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
                <div class="contactapp-content">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="my-3 ">
                                    <a class="contactapp-title link-dark">
                                        <h1 class="me-1">Create Wiseway</h1>
                                    </a>
                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                            <div class="hk-sidebar-togglable"></div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="contact-list-view">
                                    <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                        <div class="row">
                                            <div class="col-7 mb-3">
                                                <div class="contact-toolbar-left">
                                                    <select
                                                        class="d-flex align-items-center w-130p form-select form-select-sm">
                                                        <option selected="">Tất cả</option>
                                                        <option value="2">Đã pickup</option>
                                                        <option value="3">Đang đi lấy</option>
                                                        <option value="4">Đang chờ</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-5 mb-3">
                                                <div class="contact-toolbar-right">
                                                    <div id="" class=""><label><input type="search"
                                                                class="form-control form-control-sm"
                                                                placeholder="Search"></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12 table-responsive">
                                                <table class="table nowrap w-100 mb-5 dataTable no-footer" aria-describedby="datable_1_info"
                                                    role="grid">
                                                    <thead class="thead-primary">
                                                        <tr role="row">
                                                            <th class="" tabindex="0" rowspan="1"
                                                                colspan="1">Id</th>
                                                            <th class="fw-bold sorting" tabindex="0" rowspan="1"
                                                                colspan="1">Date</th>
                                                            <th class="fw-bold sorting" tabinDex="0" rowspan="1"
                                                                colspan="1">Id Label</th>
                                                            <th class="fw-bold sorting" tabindex="0" rowspan="1"
                                                                colspan="1">State</th>
                                                            <th class="fw-bold " tabindex="0" rowspan="1"
                                                                colspan="1">Post Code</th>
                                                            <th class="fw-bold " tabindex="0" rowspan="1"
                                                                colspan="1">Reference Code</th>
                                                            <th class="fw-bold" tabindex="0" rowspan="1"
                                                                colspan="1">Link</th>
                                                            <th class="fw-bold "></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @php
                                                            $state = ['QLD', 'WA', 'AUCKLAND'];
                                                        @endphp
                                                        @for ($i = 1; $i < 11; $i++)
                                                            @php
                                                                $rand = rand(0, 2);
                                                            @endphp
                                                            <tr class="odd">
                                                                <td>{{ $i }}</td>
                                                                <td>{{ fake()->date() }}</td>
                                                                <td class="fw-bold text-primary">
                                                                    <a href="">D{{ rand(1000000, 9999999) }}</a>
                                                                </td>
                                                                <td class="text-centerfw-bold ">
                                                                    SGN{{ $state[$rand] }}
                                                                </td>
                                                                <td class="fw-bold text-primary">
                                                                    {{ rand(1000, 9999) }}
                                                                </td>
                                                                <td class="">
                                                                    {{ rand(1000000000, 9999999999) }}
                                                                </td>
                                                                <td>
                                                                    <a href="https://kango-post.com/view/labelau/AU/D0669207.pdf"
                                                                        target="_blank" class="btn btn-sm btn-waning"><i
                                                                            class="fas fa-print"></i>Print Label</a>
                                                                </td>
                                                                <td>
                                                                    <button class="btn btn-icon btn-soft-danger btn-lg"
                                                                        onclick="onDelete()">
                                                                        <i class="fas fa-trash"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        @endfor
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-center mt-3">
                                            <x-pagination-demo />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    <!--  Label Modal -->
    <div class="modal fade " id="labelModal" tabindex="-1" role="dialog" aria-labelledby="" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h5 class="modal-title" style="color:white">Cập nhật Label đã tạo AUPOSTE</h5>
                    <button type="button" style="color:white" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <strong>Dán mã vào bên dưới sau 5 phút cập nhật file CSV tạo label AUPOSTE</strong>
                    <div class="col-sm-12 form-group">
                        <textarea class="form-control mnh-100p" rows="4" placeholder=""></textarea>
                    </div>
                    <p>
                        Cập nhật mã(referenceNo) với định dạng Example:
                        <br>
                        AU299990054173
                        <br>
                        AU299990054174
                        <br>
                        AU299990054175
                    </p>
                </div>
                <div class="modal-footer align-items-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Lưu</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Label Modal -->

    <!--  Send Modal -->
    <div class="modal fade " id="sendModal" tabindex="-1" role="dialog" aria-labelledby="" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h5 class="modal-title" style="color:white">Send Manifests</h5>
                    <button type="button" style="color:white" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <strong>This service will inform the Final Mile Carrier the consignments are final and will be lodge in
                        the future.
                        <br>
                        • Upon sending the manifest, you will be invoiced for the consignment manifested.
                        <br>
                        • Lodging consignments before you send manifests will also incur additional charges..</strong>
                    <div class="col-sm-12 form-group">
                        <textarea class="form-control mnh-100p" rows="4" placeholder=""></textarea>
                    </div>
                    <p>
                        Cập nhật mã(reference No) với định dạng Example:
                        <br>
                        AU299990054173
                        <br>
                        AU299990054174
                        <br>
                        AU299990054175
                    </p>
                </div>
                <div class="modal-footer align-items-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Lưu</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Send Modal -->

    @push('scripts')
        <!-- Dropify JS -->
        <script src="{{ asset('assets/vendors/dropify/dist/js/dropify.min.js') }}"></script>
        <script src="{{ asset('assets/dist/js/dropify-data.js') }}"></script>

        <script>
            // Hàm mở modal
            function openModal() {
                $('#rulesModal').modal('show');
            }
            $(".select2").select2();

            function onDelete() {
                Swal.fire({
                    title: "Bạn có chắc chắn?",
                    text: "Bạn có muốn xóa đối tượng này không",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Có",
                    cancelButtonText: "Không"
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: "Deleted!",
                            text: "Your file has been deleted.",
                            icon: "success"
                        });
                    }
                });
            }
        </script>
    @endpush
@endsection
