<style>
    .center {
        margin: 0 auto;
        text-align: center;
    }

    /* barcode container */
    .anim-box {
        position: relative;
        width: 220px;
        height: 70px;
        /* padding: 25px 30px; */
        transition: transform .6s ease-out;
    }

    /* adds the 4 corners */
    .anim-box:before,
    .anim-box:after,
    .anim-box>:first-child:before,
    .anim-box>:first-child:after {
        position: absolute;
        width: 10%;
        height: 15%;
        border-color: white;
        border-style: solid;
        content: ' ';
    }

    /* top left corner */
    .anim-box:before {
        top: 0;
        left: 0;
        border-width: 2px 0 0 2px;
    }

    /* top right corner */
    .anim-box:after {
        top: 0;
        right: 0;
        border-width: 2px 2px 0 0;
    }

    /* bottom right corner */
    .anim-box>:first-child:before {
        bottom: 0;
        right: 0;
        border-width: 0 2px 2px 0;
    }

    /* bottom left corner */
    .anim-box>:first-child:after {
        bottom: 0;
        left: 0;
        border-width: 0 0 2px 2px;
    }



    /* grow on hover */
    .anim-box {
        transform: scale(1.5, 2);
    }

    .anim-box .scanner {
        animation-play-state: running;
    }

    /* animated laser beam */
    .scanner {
        width: 100%;
        height: 3px;
        background-color: red;
        opacity: 0.7;
        position: relative;
        box-shadow: 0px 0px 8px 10px rgba(170, 11, 23, 0.49);
        top: 50%;
        animation-name: scan;
        animation-duration: 4s;
        animation-timing-function: linear;
        animation-iteration-count: infinite;
        animation-play-state: paused;
    }

    @keyframes scan {
        0% {
            box-shadow: 0px 0px 8px 10px rgba(170, 11, 23, 0.49);
            top: 50%;
        }

        25% {
            box-shadow: 0px 6px 8px 10px rgba(170, 11, 23, 0.49);
            top: 5px;
        }

        75% {
            box-shadow: 0px -6px 8px 10px rgba(170, 11, 23, 0.49);
            top: 98%;
        }
    }
</style>
<div class="position-absolute top-50 start-50 translate-middle">
    <div class='spacer'></div>
    <div class='anim-box center spacer'>
        <!-- empty first child used for corners -->
        <div></div>
        <div class='scanner'></div>
    </div>
    <div class='spacer'></div>
</div>
