@if ($paginator->hasPages())
    <nav class="pagination-wrap d-inline-block" aria-label="Page navigation example">
        <ul class="pagination custom-pagination pagination-rounded">
            {{-- Previous Page Link --}}
            <li class="page-item {{ $paginator->onFirstPage() ? 'disabled' : '' }}">
                <a class="page-link" href="{{ $paginator->onFirstPage() ? 'javascript:void(0);' : $paginator->previousPageUrl() }}">
                    Về trước
                </a>
            </li>

            {{-- Pagination Elements --}}
            {{-- Always show first page link --}}
            <li class="page-item {{ $paginator->currentPage() == 1 ? 'active' : '' }}">
                <a class="page-link" href="{{ $paginator->url(1) }}">1</a>
            </li>

            @if($paginator->currentPage() > 3)
                <li class="page-item disabled"><span class="page-link">...</span></li>
            @endif

            {{-- Show three pages before and after current page --}}
            @foreach(range(1, $paginator->lastPage()) as $i)
                @if($i >= $paginator->currentPage() - 2 && $i <= $paginator->currentPage() + 2)
                    @if ($i != 1 && $i != $paginator->lastPage())
                        <li class="page-item {{ $paginator->currentPage() == $i ? 'active' : '' }}">
                            <a class="page-link" href="{{ $paginator->url($i) }}">{{ $i }}</a>
                        </li>
                    @endif
                @endif
            @endforeach

            @if($paginator->currentPage() < $paginator->lastPage() - 3)
                <li class="page-item disabled"><span class="page-link">...</span></li>
            @endif

            {{-- Always show last page link --}}
            @if($paginator->lastPage() > 1)
                <li class="page-item {{ $paginator->currentPage() == $paginator->lastPage() ? 'active' : '' }}">
                    <a class="page-link" href="{{ $paginator->url($paginator->lastPage()) }}">{{ $paginator->lastPage() }}</a>
                </li>
            @endif

            {{-- Next Page Link --}}
            <li class="page-item {{ !$paginator->hasMorePages() ? 'disabled' : '' }}">
                <a class="page-link" href="{{ $paginator->hasMorePages() ? $paginator->nextPageUrl() : 'javascript:void(0);' }}">
                    Về sau
                </a>
            </li>
        </ul>
    </nav>
@endif
