<style>
    .spinner-container {
        display: none;
        /* El spinner estará oculto inicialmente */
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.9);
        /* Fondo oscuro */
        z-index: 9999;
        /* Para asegurarnos de que esté por encima de otros elementos */
    }

    .spinner {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 80px;
        height: 80px;
        display: flex;
        justify-content: center;
        align-items: center;
        position: relative;
    }

    .spinner div {
        width: 14px;
        height: 14px;
        background-color: #4285F4;
        /* Azul de Google */
        position: absolute;
        top: 0;
        left: 50%;
        transform-origin: 50% 40px;
        /* Punto de giro en el centro del spinner */
        border-radius: 50%;
        /* Hacer que los elementos sean esferas */
        animation: spin 1.2s linear infinite;
    }

    .spinner div:nth-child(1) {
        background-color: #4285F4;
        /* Azul de Google */
        transform: rotate(0deg);
        animation-delay: 0s;
    }

    .spinner div:nth-child(2) {
        background-color: #EA4335;
        /* Rojo de Google */
        transform: rotate(45deg);
        animation-delay: 0.15s;
    }

    .spinner div:nth-child(3) {
        background-color: #FBBC05;
        /* Amarillo de Google */
        transform: rotate(90deg);
        animation-delay: 0.3s;
    }

    .spinner div:nth-child(4) {
        background-color: #34A853;
        /* Verde de Google */
        transform: rotate(135deg);
        animation-delay: 0.45s;
    }

    .spinner div:nth-child(5) {
        background-color: #4285F4;
        /* Azul de Google */
        transform: rotate(180deg);
        animation-delay: 0.6s;
    }

    .spinner div:nth-child(6) {
        background-color: #EA4335;
        /* Rojo de Google */
        transform: rotate(225deg);
        animation-delay: 0.75s;
    }

    .spinner div:nth-child(7) {
        background-color: #FBBC05;
        /* Amarillo de Google */
        transform: rotate(270deg);
        animation-delay: 0.9s;
    }

    .spinner div:nth-child(8) {
        background-color: #34A853;
        /* Verde de Google */
        transform: rotate(315deg);
        animation-delay: 1.05s;
    }

    @keyframes spin {

        0%,
        100% {
            opacity: 1;
        }

        50% {
            opacity: 0.3;
        }
    }
</style>
<div class="spinner-container">
    <div class="spinner">
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <div></div>
    </div>
</div>

@push('scripts')
    <script>
        function showLoading(result) {
            if (result) {
                document.querySelector('.spinner-container').style.display = 'block';
            } else {
                document.querySelector('.spinner-container').style.display = 'none';
            }
        }
    </script>
@endpush
