<script src="{{ asset('assets/vendors/dynamsoft/dynamsoft-core@3.2.10/dist/core.js') }}"></script>
<script src="{{ asset('assets/vendors/dynamsoft/dynamsoft-license@3.2.10/dist/license.js') }}"></script>
<script src="{{ asset('assets/vendors/dynamsoft/dynamsoft-utility@1.2.10/dist/utility.js') }}"></script>
<script src="{{ asset('assets/vendors/dynamsoft/dynamsoft-barcode-reader@10.2.10/dist/dbr.js') }}"></script>
<script src="{{ asset('assets/vendors/dynamsoft/dynamsoft-capture-vision-router@2.2.10/dist/cvr.js') }}"></script>
<script src="{{ asset('assets/vendors/dynamsoft/dynamsoft-camera-enhancer@4.0.2/dist/dce.js') }}"></script>


<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-center">
            <div id="div-ui-container" style="width: 100%; height: 80vh"></div>
        </div>
        <input type="text" class="form-control mt-3" id="scanner" readonly>
    </div>
</div>


@push('scripts')
    <script>
        if (location.protocol === "file:") {
            const message =
                `The page is opened via file:// and our SDKs may not work properly. Please open the page via https:// or host it on "http://localhost/".`;
            console.warn(message);
            // alert(message);
        }
    </script>
    <script>
        /** LICENSE ALERT - README
         * To use the library, you need to first specify a license key using the API "initLicense()" as shown below.
         */

        Dynamsoft.License.LicenseManager.initLicense(
            "DLS2eyJoYW5kc2hha2VDb2RlIjoiMTAyODM5NDQyLVRYbFhaV0pRY205cSIsIm1haW5TZXJ2ZXJVUkwiOiJodHRwczovL21kbHMuZHluYW1zb2Z0b25saW5lLmNvbSIsIm9yZ2FuaXphdGlvbklEIjoiMTAyODM5NDQyIiwic3RhbmRieVNlcnZlclVSTCI6Imh0dHBzOi8vc2Rscy5keW5hbXNvZnRvbmxpbmUuY29tIiwiY2hlY2tDb2RlIjoyMTQzOTQ1OTY0fQ=="
        );


        Dynamsoft.Core.CoreModule.loadWasm(["DBR"]);

        (async () => {
            try {
                // Create a `CameraEnhancer` instance for camera control and a `CameraView` instance for UI control.
                const cameraView = await Dynamsoft.DCE.CameraView.createInstance();
                const cameraEnhancer =
                    await Dynamsoft.DCE.CameraEnhancer.createInstance(cameraView);
                document
                    .querySelector("#div-ui-container")
                    .append(cameraView.getUIElement()); // Get default UI and append it to DOM.

                // Create a `CaptureVisionRouter` instance and set `CameraEnhancer` instance as its image source.
                const router =
                    await Dynamsoft.CVR.CaptureVisionRouter.createInstance();
                router.setInput(cameraEnhancer);

                // Define a callback for results.
                const resultReceiver = new Dynamsoft.CVR.CapturedResultReceiver();
                resultReceiver.onDecodedBarcodesReceived = (result) => {
                    if (!result.barcodeResultItems.length) return;

                 
                    document.getElementById('scanner').value = '';
                    let count = 0;
                    for (let item of result.barcodeResultItems) {
                        // resultsContainer.append(
                        //     `${item.formatString}: ${item.text}`,
                        //     document.createElement('br'),
                        //     document.createElement('hr'),
                        // );
                        document.getElementById('scanner').value = item.text
                        if (count < 1) {
                            Swal.fire({
                                title: "Mã của bạn",
                                html: `<div class="px-3"><input type="text" class="form-control mt-3" id="scanner" value="${item.text}" readonly></div>`,
                                icon: "success"
                            });
                        }
                        count++;
                    }
                };
                router.addResultReceiver(resultReceiver);

                // Filter out unchecked and duplicate results.
                const filter = new Dynamsoft.Utility.MultiFrameResultCrossFilter();
                filter.enableResultCrossVerification("barcode", true); // Filter out unchecked barcodes.
                // Filter out duplicate barcodes within 3 seconds.
                filter.enableResultDeduplication("barcode", true);
                filter.setDuplicateForgetTime("barcode", 3000);
                await router.addResultFilter(filter);

                // Open camera and start scanning single barcode.
                await cameraEnhancer.open();
                await router.startCapturing("ReadSingleBarcode");
            } catch (ex) {
                let errMsg = ex.message || ex;
                // console.error(errMsg);
                // alert(errMsg);
            }
        })();
    </script>
@endpush
