@extends('layouts.app')
@section('content')
    <!-- Page Header -->
    @php
        $file = asset('assets/file/bulk-upload.xlsx');
        $html_file = '<div class="mb-3">Tải file mẫu: <a href="' . $file . '">tại đây</a></div>';
    @endphp

    <div class="hk-pg-wrapper pb-3">
        <div class="fmapp-wrap fmapp-sidebar-toggle">
            <div class="fmapp-content p-0">
                <div class="fmapp-detail-wrap">
                    <header class="fm-header">
                        <div class="d-flex align-items-center flex-grow-1">
                            <a class="fmapp-title link-dark">
                                <h1>Bulk Upload</h1>
                            </a>
                            <div class="mx-3 flex-grow-1 mw-400p">
                                <div class="input-group">
                                    <span class="input-affix-wrapper">
                                        <input type="file" class="form-control" id="upload-file-excel">
                                        <span class="input-suffix">
                                            <i class="fa fa-cloud-upload-alt"></i>
                                        </span>
                                    </span>
                                    <button class="btn btn-primary" id="create_bill">
                                        Tạo bill
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="fm-options-wrap">
                            <a class="btn btn-icon btn-rounded btn-flush-dark flush-soft-hover btn-sm mt-1"
                                href="{{ $file }}" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                title="Tải xuống file mẫu">
                                <span class="icon">
                                    <i class="fa fa-cloud-download-alt"></i>
                                </span>
                            </a>
                            <label class="btn btn-icon btn-rounded btn-flush-dark flush-soft-hover btn-sm mt-1"
                                data-bs-toggle="offcanvas" data-bs-target="#offcanvasGuide" aria-controls="offcanvasExample"
                                data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hướng dẫn">
                                <span class="icon">
                                    <i class="fa fa-question-circle"></i>
                                </span>
                            </label>
                            <div class="v-separator d-lg-inline-block d-none"></div>
                            <div class="dropdown-menu dropdown-menu-end"></div>
                            <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover hk-navbar-togglable d-lg-inline-block d-none"
                                href="#" data-bs-toggle="tooltip" data-bs-placement="top" title=""
                                data-bs-original-title="Ẩn/hiện thanh menu">
                                <span class="icon">
                                    <span class="feather-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="feather feather-chevron-up">
                                            <polyline points="18 15 12 9 6 15"></polyline>
                                        </svg>
                                    </span>
                                    <span class="feather-icon d-none">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="feather feather-chevron-down">
                                            <polyline points="6 9 12 15 18 9"></polyline>
                                        </svg>
                                    </span>
                                </span>
                            </a>
                        </div>
                    </header>
                    <div class="fm-body">
                        <div data-simplebar="init" class="nicescroll-bar">
                            <x-loading />
                            <div class="simplebar-wrapper" style="margin: -20px;">
                                <div class="simplebar-height-auto-observer-wrapper">
                                    <div class="simplebar-height-auto-observer"></div>
                                </div>
                                <div class="simplebar-mask">
                                    <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                                        <div class="simplebar-content-wrapper"
                                            style="height: 100%; overflow: hidden scroll;">
                                            <div class="simplebar-content" style="padding: 20px;">
                                                <div class="file-list-view">
                                                    <ul class="nav nav-tabs nav-line nav-icon nav-light" role="tablist">
                                                        <li class="nav-item" role="presentation">
                                                            <a class="nav-link active" data-bs-toggle="tab"
                                                                href="#list_service" aria-selected="false" role="tab">
                                                                <span class="nav-link-text">
                                                                    Danh sách các quốc gia và dịch vụ
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#cloud_doc"
                                                                aria-selected="true" role="tab" tabindex="-1">
                                                                <span class="nav-link-text">Hướng dẫn sử dụng</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                    <div class="tab-content">
                                                        <div class="tab-pane fade active show" id="list_service"
                                                            role="tabpanel">
                                                            <div class="row mt-5">
                                                                <div class="col-sm-8">
                                                                    <div class="card">
                                                                        <div
                                                                            class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                                                                            <span>
                                                                                <i class='bx bx-globe'></i>
                                                                            </span>
                                                                            Quốc gia và dịch vụ
                                                                        </div>
                                                                        <div class="card-body">
                                                                            <div class="mb-3 row">
                                                                                <div class="col-sm-3">
                                                                                    <div class="form-group">
                                                                                        <label id="label_country"
                                                                                            class="form-label fs-8">
                                                                                            Quốc gia (Country) *
                                                                                        </label>
                                                                                        <select
                                                                                            class="form-control select2 required"
                                                                                            id="receiver_country_id"
                                                                                            name="receiver_country_id">
                                                                                            <option value="">
                                                                                                To Country
                                                                                            </option>
                                                                                            @foreach ($countries as $country)
                                                                                                <option
                                                                                                    value="{{ $country['country_id'] }}">
                                                                                                    {{ $country['country_name'] }}
                                                                                                </option>
                                                                                            @endforeach
                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-sm-3">
                                                                                    <div class="form-group">
                                                                                        <label id="label_promotion_flg" class="form-label fs-8">
                                                                                            Loại dịch vụ:
                                                                                        </label>
                                                                                        <select class="form-control select2" id="promotion_flg" name="promotion_flg">
                                                                                            <option value="" selected>Tất cả</option>
                                                                                            <option value="{{ NO_PROMOTION }}">Chuyên tuyến</option>
                                                                                            <option value="{{ IS_EPACKET }}">E-Package</option>
                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-sm-6">
                                                                                    <label class="form-label fs-8">
                                                                                        Tìm kiếm
                                                                                    </label>
                                                                                    <input type="text" id="keywords" class="form-control" placeholder="Search">
                                                                                </div>
                                                                            </div>
                                                                            <div class="" id="content-service">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="card">
                                                                        <div
                                                                            class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                                                                            <span><i
                                                                                    class='bx bx-building-house'></i></span>Chi
                                                                            nhánh</span>
                                                                        </div>
                                                                        <div class="card-body mt-4">

                                                                            <div class="table-responsive">
                                                                                <table class="table table-hover mb-0">
                                                                                    <thead class="">
                                                                                        <tr>
                                                                                            <th class="fw-bold"
                                                                                                scope="col">Mã chi
                                                                                                nhánh</th>
                                                                                            <th class="fw-bold"
                                                                                                scope="col">Tên chi
                                                                                                nhánh</th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        @foreach ($branchs as $branch)
                                                                                            <tr>
                                                                                                <td>{{ isset($branch['branch_name']) ? $branch['branch_name'] : '' }}
                                                                                                </td>
                                                                                                <td>{{ isset($branch['branch_description']) ? $branch['branch_description'] : '' }}
                                                                                                </td>
                                                                                            </tr>
                                                                                        @endforeach
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="card mt-5">
                                                                        <div
                                                                            class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                                                                            <span><i class='bx bxs-cube'></i></span>Package
                                                                            Types</span>
                                                                        </div>
                                                                        <div class="card-body mt-3">
                                                                            <table class="table table-hover mb-0">
                                                                                <thead class="">
                                                                                    <tr>
                                                                                        <th class="fw-bold"
                                                                                            scope="col">Mã</th>
                                                                                        <th class="fw-bold"
                                                                                            scope="col">Tên</th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                    @foreach ($package_types as $key => $package_type)
                                                                                        <tr>
                                                                                            <th scope="row">
                                                                                                {{ $key }}</th>
                                                                                            <th scope="row">
                                                                                                {{ $package_type }}</th>
                                                                                        </tr>
                                                                                    @endforeach
                                                                                </tbody>
                                                                            </table>
                                                                        </div>
                                                                    </div>
                                                                    <div class="card mt-5">
                                                                        <div
                                                                            class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                                                                            <span><i class='bx bxs-cube'></i></span>Exports
                                                                            as</span>
                                                                        </div>
                                                                        <div class="card-body mt-3">
                                                                            <ul class="list-group">
                                                                                <table class="table table-hover mb-0">
                                                                                    <thead class="">
                                                                                        <tr>
                                                                                            <th class="fw-bold"
                                                                                                scope="col">Mã</th>
                                                                                            <th class="fw-bold"
                                                                                                scope="col">Tên</th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        @foreach ($invoice_exports_as as $key => $export)
                                                                                            <tr>
                                                                                                <th scope="row">
                                                                                                    {{ $key }}
                                                                                                </th>
                                                                                                <th scope="row">
                                                                                                    {{ $export }}
                                                                                                </th>
                                                                                            </tr>
                                                                                        @endforeach
                                                                                    </tbody>
                                                                                </table>
                                                                            </ul>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="tab-pane" id="cloud_doc" role="tabpanel">
                                                            {!! $html_file !!}
                                                            @include('bulk-upload.html_guide')
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="offcanvas offcanvas-start w-50" tabindex="-1" id="offcanvasGuide" aria-labelledby="offcanvasTopLabel">
        <div class="offcanvas-header bg-primary">
            <h5 class="text-white" id="offcanvasGuideLabel">Hướng dẫn tạo nhiều Shipment</h5>
            <button type="button" class="btn-close text-reset text-white" data-bs-dismiss="offcanvas"
                aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            {!! $html_file !!}
            @include('bulk-upload.html_guide')

        </div>
    </div>
    @push('scripts')
        <!-- Data Table JS -->
        <script src="{{ asset('assets/vendors/xlsx/dist/xlsx.full.min.js') }}"></script>
        <script src="{{ asset('assets/vendors/file-saver/dist/FileSaver.min.js') }}"></script>
        <script>
            $(".select2").select2();
        </script>

        <script src="{{ asset('js/shipment/bulk-upload.js') }}"></script>
    @endpush
@endsection
