@extends('layouts.app')
@section('content')
    <div class="hk-wrapper hk-pg-auth bg-primary-dark-3" data-footer="simple">
        <!-- Main Content -->

        <div class="hk-pg-wrapper pt-0 pb-xl-0 pb-5">
            <div class="hk-pg-body pt-0 pb-xl-0">
                <!-- Container -->
                <div class="container-xxl">

                    <!-- Row -->
                    <div class="row">
                        <div class="col-sm-10 position-relative mx-auto">
                            <div class="auth-content py-8">

                                <form class="w-100" id="myForm">
                                    <div class="row">
                                        <div class="col-lg-4 col-md-6 mx-auto">
                                            @if (isset($data['mess-err']))
                                                <h3 class="text-white">{{ $data['mess-err'] }}
                                                </h3>
                                            @else
                                                <div class="card card-flush bg-transparent">
                                                    <div class="card-body text-center">
                                                        <div
                                                            class="avatar avatar-xl avatar-rounded  border-light position-relative mb-3">
                                                            @if (empty($data->user_logo))
                                                                <span
                                                                    class="initial-wrap">{{ customTextAvatar($data->user_contact_name) }}</span>
                                                            @else
                                                                <img src="{{ asset($data->user_logo) }}" alt="user"
                                                                    class="avatar-img">
                                                            @endif

                                                            <div
                                                                class="badge-icon badge-icon-xxs text-primary position-bottom-end-overflow-1">
                                                                <div class="badge-icon-wrap">
                                                                    <i class="ri-lock-fill"></i>
                                                                </div>
                                                                <svg xmlns="http://www.w3.org/2000/svg"
                                                                    viewBox="0 0 127 127">
                                                                    <g data-name="Ellipse 302" transform="translate(8 8)"
                                                                        stroke-width="3">
                                                                        <circle cx="55.5" cy="55.5" r="55.5"
                                                                            stroke="currentColor"></circle>
                                                                        <circle cx="55.5" cy="55.5" r="59.5"
                                                                            fill="currentColor"></circle>
                                                                    </g>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <h4 class="text-white">{{ $data->user_contact_name }}</h4>
                                                        <p class="p-sm mb-4 text-white opacity-55">{{ $data->user_name }}
                                                        </p>
                                                        <div class="row gx-3">
                                                            <div class="form-group col-lg-12">
                                                                <input class="form-control" placeholder="Mật khẩu mới"
                                                                    value="" type="password" id="password">
                                                                <div id="password_err" class="invalid-feedback"></div>
                                                            </div>
                                                            <div class="form-group col-lg-12">
                                                                <input class="form-control" placeholder="Xác nhận mật khẩu"
                                                                    value="" type="password" id="confirm_password">
                                                                <div id="confirm_password_err" class="invalid-feedback">
                                                                </div>

                                                            </div>
                                                        </div>
                                                        <button class="btn btn-primary" onclick="onupdate()">Xác
                                                            nhận</button>
                                                    </div>
                                                </div>

                                                <div class="text-center text-white mt-3 h5" id="time-end"></div>
                                            @endif
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- /Row -->
                </div>
                <!-- /Container -->
            </div>
            <!-- /Page Body -->


        </div>
        <!-- /Main Content -->
    </div>

    @push('scripts')
        <script>
            setIcon.thickLeft3()

            if (document.getElementById('time-end')) {
                // Đặt thời gian bắt đầu
                const startTime = new Date(`{{ $data['created_at'] }}`).getTime();

                // Tính toán thời gian kết thúc (5 phút sau thời gian bắt đầu)
                const endTime = startTime + 5 * 60 * 1000;

                // Cập nhật đếm ngược mỗi giây
                const x = setInterval(function() {
                    // Lấy thời gian hiện tại
                    const now = new Date().getTime();

                    // Tính toán thời gian còn lại
                    const distance = endTime - now;

                    // Tính toán thời gian còn lại theo phút và giây
                    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                    // Hiển thị kết quả trong phần tử với id="countdown"
                    document.getElementById("time-end").innerHTML = minutes + ": " + seconds;

                    // Nếu đếm ngược kết thúc, hiển thị một thông báo
                    if (distance < 0) {
                        clearInterval(x);
                        document.getElementById("time-end").innerHTML = "0:0";
                        window.location.reload();
                    }
                }, 1000);
            }

            document.getElementById("myForm").addEventListener("submit", function(event) {
                // Ngăn chặn hành động submit mặc định của form
                event.preventDefault();

                onupdate()
            });

            function onupdate() {
                clearValErr();
                let _url = window.location.origin + '/new-password';
                let _data = {
                    email: `{{ $data['user_name'] }}`,
                    password: $('#password').val(),
                    confirm_password: $('#confirm_password').val(),
                };
                const callback = (res) => {
                    if (res.status == 200) {
                        
                        showMessage({
                            icon: 'success',
                            title: 'Thông báo',
                            text: res.message
                        })
                        window.location.href = typeof res.route === undefined ? window.location.origin : res.route
                    } else if (res.status == 422) {
                        var errors = res.error.responseJSON.errors; // Lấy thông điệp lỗi từ phản hồi JSON
                        $.each(errors, function(key, value) {
                            // Hiển thị thông điệp lỗi tương ứng với mỗi trường
                            $('#' + key + '_err').text(value[0]);
                            $('#' + key + '_err').addClass('d-block')
                        });
                    } else {
                        let alert = {
                            icon: 'warning',
                            title: 'Cảnh báo',
                            text: res.message
                        }
                        showMessage(alert)
                    }
                }

                ajaxContants(_url, 'POST', _data, callback)
            }

            function clearValErr() {
                $('#password_err').text('');
                $('#password_err').removeClass('d-block')
                $('#confirm_password_err').text('');
                $('#confirm_password_err').removeClass('d-block')
            }
        </script>
    @endpush
@endsection
