@extends('layouts.app')
@section('content')
    <div class="hk-wrapper hk-pg-auth bg-primary-dark-3" data-footer="simple">
        <!-- Main Content -->

        <div class="hk-pg-wrapper pt-0 pb-xl-0 pb-5">
            <div class="hk-pg-body pt-0 pb-xl-0">
                <!-- Container -->
                <div class="container-xxl">

                    <!-- Row -->
                    <div class="row">
                        <a class="p-sm m-3 text-white opacity-55" href="{{ route('login.show') }}">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                height="24" width="24" id="Arrow-Thick-Left-3--Streamline-Ultimate">
                                <desc>Arrow Thick Left 3 Streamline Icon: https://streamlinehq.com</desc>
                                <path stroke="#FFFFFF" stroke-linecap="round" stroke-linejoin="round"
                                    d="M13.243 3.75c0.1482 0.00013 0.2931 0.04419 0.4163 0.12661 0.1232 0.08242 0.2193 0.1995 0.276 0.33647 0.0567 0.13696 0.0715 0.28766 0.0427 0.43306 -0.0289 0.1454 -0.1002 0.27897 -0.205 0.38386l-4.72 4.72H22.5c0.1989 0 0.3897 0.07902 0.5303 0.21967 0.1407 0.14063 0.2197 0.33143 0.2197 0.53033v3c0 0.1989 -0.079 0.3897 -0.2197 0.5303 -0.1406 0.1407 -0.3314 0.2197 -0.5303 0.2197H9.053l4.72 4.72c0.1048 0.1049 0.1761 0.2385 0.205 0.3839 0.0288 0.1454 0.014 0.2961 -0.0427 0.433 -0.0567 0.137 -0.1528 0.2541 -0.276 0.3365 -0.1232 0.0824 -0.2681 0.1265 -0.4163 0.1266H9.311c-0.19702 0.0001 -0.39212 -0.0386 -0.57417 -0.114 -0.18205 -0.0753 -0.34748 -0.1857 -0.48683 -0.325L0.969998 12.53c-0.069664 -0.0696 -0.12493 -0.1522 -0.162638 -0.2431 -0.037707 -0.091 -0.057116 -0.1885 -0.057116 -0.2869 0 -0.0984 0.019409 -0.1959 0.057116 -0.2869 0.037708 -0.0909 0.092974 -0.1735 0.162638 -0.2431L8.25 4.189c0.13935 -0.13927 0.30478 -0.24972 0.48683 -0.32504 0.18205 -0.07533 0.37715 -0.11405 0.57417 -0.11396h3.932Z"
                                    stroke-width="1.5"></path>
                            </svg>
                            Trở về đăng nhập
                        </a>
                        <div class="col-sm-10 position-relative mx-auto">
                            <div class="auth-content py-8">
                                
                                <form class="w-100" id="myForm">
                                    <div class="row">
                                        <div class="col-lg-4 col-md-6 mx-auto">
                                            <div class="card card-flush bg-transparent">
                                                <div class="card-body text-center">
                                                    <div class="avatar avatar-xl avatar-rounded  position-relative mb-3">
                                                        <img src="{{ asset(LOGO) }}" alt="user"
                                                            class="avatar-img">
                                                        <div
                                                            class="badge-icon badge-icon-xxs text-primary position-bottom-end-overflow-1">
                                                            <div class="badge-icon-wrap">
                                                                <i class="ri-lock-fill"></i>
                                                            </div>
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 127 127">
                                                                <g data-name="Ellipse 302" transform="translate(8 8)"
                                                                    stroke-width="3">
                                                                    <circle cx="55.5" cy="55.5" r="55.5"
                                                                        stroke="currentColor"></circle>
                                                                    <circle cx="55.5" cy="55.5" r="59.5"
                                                                        fill="currentColor"></circle>
                                                                </g>
                                                            </svg>
                                                        </div>
                                                    </div>
                                                    <h4 class="text-white">{{ $data->user_contact_name }}</h4>
                                                    <p class="p-sm mb-4 text-white opacity-55">{{ $data->user_name }}</p>
                                                    <div class="row gx-3">
                                                        <div class="form-group col-lg-12">
                                                            <input class="form-control" placeholder="Mã xác nhận"
                                                                value="" type="text" id="code">
                                                        </div>
                                                    </div>
                                                    <button class="btn btn-primary" onclick="onConfirmLogin()">Xác
                                                        nhận</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- /Row -->
                </div>
                <!-- /Container -->
            </div>
            <!-- /Page Body -->


        </div>
        <!-- /Main Content -->
    </div>

    @push('scripts')
        <script>
            setIcon.thickLeft3()
        </script>
        <script src="{{ asset('js/auth/accuracy.js') }}"></script>
    @endpush
@endsection
