<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>Date Create</th>
                <th>Người tạo</th>
                <th>ID Bill Kango</th>
                <th>WEIGHT(KG)</th>
                <th>Weight Diff</th>
                <th>Price Created</th>
                <th>Price Actual</th>
                <th>Price Diff</th>
                <th>Note</th>
            </tr>
        </thead>
        <tbody>
            @php
                $colors = ['secondary', 'success', 'warning', 'danger'];
            @endphp
            @foreach ($shipments as $key => $shipment)
                @php
                    $package_length = collect($shipment['packages'])->sum('package_length');
                    $package_width = collect($shipment['packages'])->sum('package_width');
                    $package_height = collect($shipment['packages'])->sum('package_height');
                    $package_weight = collect($shipment['packages'])->sum('package_weight');
                    $package_charged_weight = collect($shipment['packages'])->sum('package_charged_weight');

                    $package_length_actual = collect($shipment['packages'])->sum('package_length_actual');
                    $package_width_actual = collect($shipment['packages'])->sum('package_width_actual');
                    $package_height_actual = collect($shipment['packages'])->sum('package_height_actual');
                    $package_weight_actual = collect($shipment['packages'])->sum('package_weight_actual');
                    $package_charged_weight_actual = collect($shipment['packages'])->sum(
                        'package_charged_weight_actual',
                    );
                @endphp
                <tr class="odd">
                    <td>
                        <button id="btn_shipment_{{ $key }}" onclick="showShipmentDetail('{{ $key }}')"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#shipment_{{ $key }}"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>{{ formatFullDate($shipment['created_at']) }}</td>
                    <td>{{ $shipment['user']['user_contact_name'] }}</td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="{{ route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']]) }}">
                            {{ $shipment['shipment_code'] }}
                        </a>
                    </td>
                    <td class="align-items-center">
                        {{ formatNumber($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE ? $package_charged_weight : $package_charged_weight_actual) }}
                    </td>
                    @if ($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE)
                        <td class="text-success">
                            0
                        </td>
                    @else
                        <td
                            class="{{ $package_charged_weight > $package_charged_weight_actual ? 'text-danger' : 'text-success' }}">
                            {{ $package_charged_weight_actual - $package_charged_weight }}
                        </td>
                    @endif

                    <td>
                        {{ formatNumber($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE ? $shipment['shipment_final_amount'] : $shipment['shipment_total_amount_actual']) }}
                    </td>
                    <td>
                        {{ formatNumber($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE ? 0 : $shipment['shipment_final_amount']) }}
                    </td>
                    @if ($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE)
                        <td class="text-success">
                            {{ formatNumber($shipment['shipment_final_amount']) }}
                        </td>
                    @else
                        <td
                            class="{{ $shipment['shipment_total_amount_actual'] < $shipment['shipment_final_amount'] ? 'text-danger' : 'text-success' }}">
                            {{ formatNumber($shipment['shipment_total_amount_actual'] - $shipment['shipment_final_amount']) }}
                        </td>
                    @endif

                    <td>
                        @if (!isGetAllData())
                            {{ $shipment['shipment_note'] }}
                        @else
                            <input type="text" class="form-control change_shipment_note"
                                data-shipment_code="{{ $shipment['shipment_code'] }}"
                                value="{{ $shipment['shipment_note'] }}">
                        @endif
                    </td>
                </tr>
                @foreach ($shipment['packages'] as $package)
                    <tr class="child collapse" id="shipment_{{ $key }}">
                        <td class="child" colspan="5">
                            <ul>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        HAWB Kango:
                                    </span>
                                    <span class="dtr-data fw-bold text-secondary">
                                        {{ $package['package_hawb_code'] }}
                                        @if ($package['package_tracking_code'])
                                            -
                                            {{ $package['package_tracking_code'] }}
                                            <a href="{{ getUrlTracking($package['package_hawb_code']) }}"
                                                target="_blank">
                                                <i class="fas fa-map-marker-alt"></i>
                                            </a>
                                        @endif
                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        Người tạo:
                                    </span>
                                    <span class="dtr-data fw-bold text-secondary">
                                        {{ $shipment['user']['user_contact_name'] }}
                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        L:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_length'] : $package['package_length_actual']) }}
                                        -
                                        H:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_width'] : $package['package_width_actual']) }}
                                        -
                                        R:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_height'] : $package['package_height_actual']) }}
                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        GW Created:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_weight'] : $package['package_weight_actual']) }}
                                        -
                                        CW Created:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_charged_weight'] : $package['package_charged_weight_actual']) }}
                                    </span>
                                </li>
                            </ul>
                        </td>
                        <td></td>
                        <td class="child" colspan="5">
                            <ul>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        Nhân viên xử lý:
                                    </span>
                                    <span class="dtr-data fw-bold text-secondary">
                                        {{ $shipment['packages'][0]['processingStaff']['user_code'] ?? '' }}
                                        -
                                        {{ $shipment['packages'][0]['processingStaff']['user_contact_name'] ?? '' }}
                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        Trạng thái:
                                    </span>
                                    <span class="dtr-data">
                                        <small class="badge badge-{{ $colors[$package['package_approve']] }}">
                                            {{ $package['package_approve_name'] }}
                                        </small>
                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        L:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_length']) }}
                                        -
                                        H:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_width']) }}
                                        -
                                        R:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_height']) }}
                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        Actual GW Created:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_weight']) }}
                                        -
                                        Actual CW Created:
                                        {{ formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_charged_weight']) }}
                                    </span>
                                </li>
                            </ul>
                        </td>
                    </tr>
                @endforeach
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $shipments->links('components.pagination') }}
</div>
