@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content px-3">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>Audit E-Packet</h1>
                                    </a>
                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                <div data-bs-toggle="tooltip" data-placement="top"
                                    data-bs-original-title="Tìm kiểm nâng cao">
                                    <span
                                        class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover no-caret d-sm-inline-block d-none"
                                        data-bs-toggle="collapse" href="#searchPlus" role="button" aria-expanded="true"
                                        aria-controls="collapseExample">
                                        <span class="icon">
                                            <span class="feather-icon">
                                                <i data-feather="search"></i>
                                            </span>
                                        </span>
                                    </span>
                                </div>
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="collapse show" id="searchPlus">
                                    <div class="card card-body">
                                        <div class="row">
                                            <div class="col-sm-3 mb-3">
                                                <label class="form-lable">Từ ngày đến ngày</label>
                                                <div class="input-group">
                                                    <span class="input-affix-wrapper">
                                                        <span class="input-prefix">
                                                            <span class="feather-icon">
                                                                <i data-feather="calendar"></i>
                                                            </span>
                                                        </span>
                                                        <input class="form-control form-wth-icon" name="shipment_daterange">
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="mb-3 col-sm-3">
                                                <label class="form-lable">Chi nhánh</label>
                                                <select class="form-control select2" name="shipment_branch_id">
                                                    <option value="">All</option>
                                                    @foreach ($branchs as $key => $branch)
                                                        <option value="{{ $branch['branch_id'] }}">
                                                            {{ $branch['branch_name'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="mb-3 col-sm-3">
                                                <label class="form-lable">Trạng thái</label>
                                                <select class="form-control select2" name="shipment_status">
                                                    <option value="">All</option>
                                                    @foreach ($shipment_status as $key => $status)
                                                        <option value="{{ $key }}">{{ $status }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="mb-3 col-sm-3">
                                                <label class="form-lable">Dịch vụ</label>
                                                <select class="form-control select2 select2-multiple" name="shipment_service_id" multiple>
                                                    @foreach ($services as $key => $service)
                                                        <option value="{{ $service['service_id'] }}">
                                                            {{ $service['service_name'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="mb-3 col-sm-3">
                                                <label for="form-lable"></label>
                                                <button type="button" class="btn btn-success btn-floating w-100"
                                                    onclick="onExportExcel()" id="btn_excel_sm">
                                                    <i class="fas fa-file-excel"></i>
                                                    Xuất file excel
                                                </button>
                                            </div>
                                            <div class="mb-3 col-sm-3">
                                                <label class="form-lable">Tìm kiếm theo</label>
                                                <select class="form-control select2" name="filter_by">
                                                    @foreach ($shipment_filter_by as $key => $filter_by)
                                                        <option value="{{ $key }}">{{ $filter_by }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="mb-3 col">
                                                <label class="form-lable">Tìm kiếm</label>
                                                <input type="text" class="form-control" name="shipment_keywords"
                                                    placeholder="Nhập nội dung bạn muốn tìm kiếm">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="contact-list-view">
                                    <x-spinner id="loading_show_table_content" />
                                    <div id="show_table_content"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')
        <!-- Dropify JS -->
        <script lang="javascript" src="{{ asset('assets/vendors/xlsx/dist/xlsx.full.min.js') }}"></script>
        <script src="{{ asset('js/audit-epacket/list.js') }}"></script>
    @endpush
@endsection