<table class="table">
    <thead>
        <tr role="row">
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER COMPANY</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER NAME</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER PHONE</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER EMAIL</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER ADDRESS 1</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER ADDRESS 2</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER CITY</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER COUNTRY</th>
            <th style="font-weight: bold; background-color: #e5ff00"h>AWB</th>
            <th style="font-weight: bold; background-color: #e5ff00">HAWB</th>
            <th style="font-weight: bold; background-color: #e5ff00">TRACKING NUMBER</th>
            <th style="font-weight: bold; background-color: #e5ff00">SERVICE</th>
            <th style="font-weight: bold; background-color: #e5ff00">DATE</th>
            <th style="font-weight: bold; background-color: #e5ff00">COMPANY</th>
            <th style="font-weight: bold; background-color: #e5ff00">CONTACT</th>
            <th style="font-weight: bold; background-color: #e5ff00">ADDRESS 1</th>
            <th style="font-weight: bold; background-color: #e5ff00">ADDRESS 2 </th>
            <th style="font-weight: bold; background-color: #e5ff00">ADDRESS 3</th>
            <th style="font-weight: bold; background-color: #e5ff00">CITY</th>
            <th style="font-weight: bold; background-color: #e5ff00">STATE/PROVINCE</th>
            <th style="font-weight: bold; background-color: #e5ff00">COUNTRY</th>
            <th style="font-weight: bold; background-color: #e5ff00"h>POSTAL CODE</th>
            <th style="font-weight: bold; background-color: #e5ff00">TELEPHONE</th>
            <th style="font-weight: bold; background-color: #e5ff00">Q TY</th>
            <th style="font-weight: bold; background-color: #e5ff00">G.W</th>
            <th style="font-weight: bold; background-color: #e5ff00">G.W ACTUAL</th>
            <th style="font-weight: bold; background-color: #e5ff00">C.W</th>
            <th style="font-weight: bold; background-color: #e5ff00">C.W ACTUAL</th>
            <th style="font-weight: bold; background-color: #e5ff00">LENGTH</th>
            <th style="font-weight: bold; background-color: #e5ff00">LENGTH ACTUAL</th>
            <th style="font-weight: bold; background-color: #e5ff00">WIDTH</th>
            <th style="font-weight: bold; background-color: #e5ff00">WIDTH ACTUAL</th>
            <th style="font-weight: bold; background-color: #e5ff00">HEIGHT</th>
            <th style="font-weight: bold; background-color: #e5ff00">HEIGHT ACTUAL</th>
            <th style="font-weight: bold; background-color: #e5ff00">TYPE</th>
            <th style="font-weight: bold; background-color: #e5ff00">DESCRIPTION OF GOODS</th>
            <th style="font-weight: bold; background-color: #e5ff00">VALUE</th>
            <th style="font-weight: bold; background-color: #e5ff00">UNIT</th>
            <th style="font-weight: bold; background-color: #e5ff00">Price Created</th>
            <th style="font-weight: bold; background-color: #e5ff00">Price Actual</th>
            <th style="font-weight: bold; background-color: #e5ff00">Price Diff</th>
            <th style="font-weight: bold; background-color: #e5ff00">Trạng thái</th>
            <th style="font-weight: bold; background-color: #e5ff00">Nv xử lý</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($data_excel as $key => $shipment)
            @php
                $area_vn = getAreaVietName($shipment['sender_city']);
                $package = $shipment['packages'][0];
                $package_types = ['Carton', 'Pallet', 'Túi(Phong bì)'];
                $is_epacket = $shipment['service']['promotion_flg'] == IS_EPACKET;
                $is_created = $shipment['shipment_status'] == SHIPMENT_STATUS_CREATE;
            @endphp
            <tr>
                <td>{{ $shipment['sender_company_name'] }}</td>
                <td>{{ $shipment['sender_contact_name'] }}</td>
                <td>{{ $shipment['sender_telephone'] }}</td>
                <td>{{ getUser($shipment['user_id'])['user_name'] }}</td>
                <td>{{ $shipment['sender_address'] }}</td>
                <td></td>
                <td>{{ $area_vn['cities'][$shipment['sender_city']] ?? '' }}</td>
                <td>VN</td>
                <td>{{ $shipment['shipment_code'] }}</td>
                <td>{{ $package['package_code'] ?? '' }}</td>
                <td>{{ $package['package_tracking_code'] ?? '' }}</td>
                <td>{{ $shipment['service']['service_name'] }}</td>
                <td>{{ formatDate($shipment['created_at']) }}</td>
                <td>{{ $shipment['receiver_company_name'] }}</td>
                <td>{{ $shipment['receiver_contact_name'] }}</td>
                <td>{{ $shipment['receiver_address_1'] }}</td>
                <td>{{ $shipment['receiver_address_2'] }}</td>
                <td>{{ $shipment['receiver_address_3'] }}</td>
                <td>{{ $shipment['city']['city_name'] ?? '' }}</td>
                <td>{{ onReturnStateShipment($shipment) }}</td>
                <td>{{ $shipment['country']['country_name'] ?? '' }}</td>
                <td>{{ $shipment['receiver_postal_code'] }}</td>
                <td>{{ $shipment['receiver_telephone'] }}</td>
                <td>1</td>

                <td>{{ $is_created ? $package['package_weight'] : $package['package_weight_actual'] }}</td>
                <td>{{ $is_created ? 0 : $package['package_weight'] }}</td>

                <td>{{ $is_created ? $package['package_converted_weight'] : $package['package_converted_weight_actual'] }} </td>
                <td>{{ $is_created ? 0 : $package['package_converted_weight'] }} </td>

                <td>{{ $is_created ? $package['package_length'] : $package['package_length_actual'] }} </td>
                <td>{{ $is_created ? 0 :$package['package_length_actual'] }} </td>

                <td>{{ $is_created ? $package['package_width'] : $package['package_width_actual'] }}</td>
                <td>{{ $is_created ? 0 : $package['package_width_actual'] }}</td>

                <td>{{ $is_created ? $package['package_height'] : $package['package_height_actual'] }} </td>
                <td>{{ $is_created ? 0 : $package['package_height_actual'] }} </td>

                <td>{{ $package_types[$package['package_type']] ?? '' }}</td>
                <td>
                    @foreach ($shipment['invoices'] as $key => $invoice)
                        <p>{{ $invoice['invoice_quantity'] }}. {{ $invoice['invoice_goods_details'] }}:
                            {{ $invoice['invoice_total_price'] }}</p>
                    @endforeach
                </td>
                <td>{{ $shipment['shipment_value'] }}</td>
                <td>USD</td>
                <td>
                    {{ formatNumber($is_created ? $shipment['shipment_final_amount'] : $shipment['shipment_total_amount_actual']) }}
                </td>
                <td>
                    {{ formatNumber($is_created ? $shipment['shipment_total_amount_actual'] : $shipment['shipment_final_amount']) }}
                </td>
                <td
                    class="{{ $shipment['shipment_final_amount'] < $shipment['shipment_total_amount_actual'] ? 'text-danger' : 'text-success' }}">
                    {{ formatNumber($shipment['shipment_final_amount'] - $shipment['shipment_total_amount_actual']) }}
                </td>
                <td>{{ $package['package_approve_name'] ?? '' }}</td>
                <td>
                    {{ $package['processingStaff']['user_code'] ?? '' }}
                    -
                    {{ $package['processingStaff']['user_contact_name'] ?? '' }}
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
