@extends('layouts.app')
@section('content')
    <style>
        .ck-editor__editable[role="textbox"] {
            min-height: 400px;
        }
    </style>
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content px-3">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <a class="blogapp-title link-dark" href="#">
                                    <h3>{{ isset($document) ? 'Cập nhật api' : 'Thêm mới Api' }}</h3>
                                </a>
                            </div>
                            <div class="blog-options-wrap">
                                @if (isset($document))
                                    <button type="button" class="btn btn-success btn-floating btn-sm"
                                        id="btn_handle_document"
                                        onclick="onUpdateApi()">Lưu</button>
                                @else
                                    <button type="button" class="btn btn-success btn-floating btn-sm"
                                        id="btn_handle_document" onclick="onCreateApi()">Lưu</button>
                                @endif
                                <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-bs-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="container-fluid">
                                    <div class="row">
                                        <div class="">
                                            <form class="edit-post-form">
                                                <div class="form-group">
                                                    <label class="form-label">Tên api</label>
                                                    <input class="form-control" id="api_title" placeholder=""
                                                        value="{{ $document['title'] ?? '' }}">
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label">Mô tả ngắn</label>
                                                    <textarea class="form-control" id="api_short_des" rows="3">{{ $document['short_des'] ?? '' }}</textarea>
                                                </div>

                                                <div class="">
                                                    <div class="">
                                                        <div class="tab-content mt-5">
                                                            <div class="tab-pane fade show active" id="tab_classic">
                                                                <div id="editor">{!! isset($document['path_content']) ? readFileText($document['path_content'])['content'] : '' !!}</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /Page Body -->
        @if (isset($document))
            <input type="text" id="api_id" value="{{ $document->api_document_id }}" hidden>
        @endif
    </div>
    @push('scripts')
        <script src="{{ asset('assets/vendors/ckeditor5/toolbar.js') }}"></script>
        <script src="{{ asset('assets/vendors/ckeditor5/build/ckeditor.js') }}"></script>
        <script></script>
        <script src="{{ asset('js/api-documnet/handle.js') }}"></script>
    @endpush
@endsection
