<div class="row">
    @foreach ($documents as $key => $value)
        <div class="col-xxl-3 col-xl-4 col-md-6">
            <div class="card card-border card-int mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="avatar avatar-sm avatar-logo btn btn-gradient-info d-flex align-items-center">
                            <i class="fas fa-link m-auto"></i>
                        </div>
                        <div class="d-flex justify-content-end m-1 p-1">
                            @if (isGetAllData())
                                <a type="button" onclick="onDeleteApi({{ $value['api_document_id'] }})"
                                    class="btn btn-icon btn-soft-danger me-1 btn-sm"><span class="icon"><i
                                            class="fa fa-trash"></i></span></a>
                                <a href="{{ route('api-document.update', ['slug' => $value['slug']]) }}"
                                    class="btn btn-icon btn-soft-primary btn-sm"><span class="icon"><i
                                            class="fa fa-pen"></i></span></a>
                            @endif
                        </div>
                    </div>
                    <div class="app-name fw-bold">
                        <a
                            href="{{ route('api-document.detail', ['slug' => $value['slug']]) }}">{{ $value['title'] }}</a>
                    </div>
                    <p class="p-sm multine-ellipsis">
                        {{ $value['short_des'] }}</p>
                </div>
            </div>
        </div>
    @endforeach
</div>
<div class="text-center mt-3">
    {{ $documents->links('components.pagination') }}
</div>
