@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content px-3">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>Biến động số dư ví</h1>
                                    </a>
                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                <div data-bs-toggle="tooltip" data-placement="top"
                                    data-bs-original-title="Tìm kiểm nâng cao">
                                    <span
                                        class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover no-caret d-sm-inline-block d-none"
                                        data-bs-toggle="collapse" href="#searchPlus" role="button" aria-expanded="true"
                                        aria-controls="collapseExample">
                                        <span class="icon">
                                            <span class="feather-icon">
                                                <i data-feather="search"></i>
                                            </span>
                                        </span>
                                    </span>
                                </div>
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="collapse show" id="searchPlus">
                                    <div class="card card-body">
                                        <div class="row">
                                            <div class="col-sm-4 mb-3">
                                                <label class="form-lable">Từ ngày đến ngày</label>
                                                <div class="input-group">
                                                    <span class="input-affix-wrapper">
                                                        <span class="input-prefix">
                                                            <span class="feather-icon">
                                                                <i data-feather="calendar"></i>
                                                            </span>
                                                        </span>
                                                        <input class="form-control form-wth-icon" name="datetimes">
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="mb-3 col-sm-4">
                                                <label class="form-lable">Trạng thái</label>
                                                <select class="form-control select2" id="wallet_fluctuaton_kind">
                                                    <option value="">Tất cả</option>
                                                    <option value="{{ PLUS }}">Cộng tiền</option>
                                                    <option value="{{ MINUS }}">Trừ tiền</option>
                                                </select>
                                            </div>
                                            <div class="mb-3 col-sm-4">
                                                <label class="form-lable">Tìm kiếm</label>
                                                <input type="text" class="form-control" name="keywords" id="keywords"
                                                    placeholder="Nhấn 'enter' tìm kiếm">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="contact-list-view">
                                    <div id="content"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')

        <script src="{{ asset('js/accountant/wallet-flucuation/index.js') }}"></script>
    @endpush
@endsection
