<div class="table-responsive">
    <table class="table table-striped mb-0">
        <thead>
            <tr>
                <th class="fw-bold" scope="col">Mã</th>
                @if (isGetAllData())
                    <th class="fw-bold" scope="col">Tài khoản</th>
                    <th class="fw-bold" scope="col">Loại TK</th>
                @endif
                <th class="fw-bold" scope="col">Trạng thái</th>
                <th class="fw-bold" scope="col">Số tiền</th>
                <th class="fw-bold" scope="col">Số dư ví</th>
                <th class="fw-bold" scope="col">Nội dung</th>
                <th class="fw-bold" scope="col">Ngày tạo</th>
            </tr>
        </thead>
        <tbody>
            @php
                $status = ['success', 'danger'];
            @endphp
            @foreach ($histories as $item)
                <tr>
                    <td class="fw-bold">{{ $item['secure_hash'] }}</td>
                    @if (isGetAllData())
                        <td class="fw-bold">{{ $item['user_contact_name'] }} [{{ $item['user_code'] }}]</td>
                        <td class="fw-bold">
                            @include('components.badges-position-name', [
                                'position_id' => $item['position_id'],
                            ])
                        </td>
                    @endif
                    <td class="d-lfex justify-content-center">
                        <span
                            class="badge badge-{{ $status[$item['kind']] ?? '' }} badge-pill">{{ $item['kind_label'] }}</span>
                    </td>
                    <td class="table-{{ $status[$item['kind']] ?? '' }}">{{ number_format($item['amount']) }}</td>
                    <td class="">
                        {{ number_format($item['wallet_amount']) }}
                    </td>
                    <td>{{ $item['content'] }}</td>
                    <td>
                        {{ formatFullDate($item['updated_at']) }}
                    </td>
                </tr>
            @endforeach
            @if (empty($item))
                <tr>
                    <td colspan="8" class="text-center">Không có dữ liệu</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $histories->links('components.pagination') }}
</div>
