@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content mx-3 p-0">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>Statement no: {{ $statement['statement_code'] }}</h1>
                                    </a>
                                </div>
                                <div class="ms-3">

                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="col-12 row justify-content-center">
                                    <div class="col-md-6">
                                        <div class="card">
                                            <div class="card-header bg-primary">
                                                <h5 class="card-title text-white">Cập nhật thanh toán</h5>
                                                <a href="{{ route('statement.detail.export', ['statement_code' => $statement['statement_code']]) }}"
                                                    target="_blank" class="btn btn-icon btn-social btn-info ms-1"><span
                                                        class="icon"><i class="fas fa-download"></i></span></a>
                                            </div>
                                            @if ($statement['statement_status'] == SUCCESS)
                                                <div class="card-body">
                                                    <div class="alert alert-success mt-3">
                                                        <p><span class="me-1 fs-5"><i
                                                                    class="far fa-check-circle"></i></span>Đã
                                                            thanh toán
                                                        </p>
                                                        <div class="d-flex flex-row">
                                                            @foreach (onConvertStrArrImage($statement['statement_images']) as $item)
                                                                <a class="p-2" href="{{ $item }}"
                                                                    target="_blank"><i class="fas fa-image"></i></a>
                                                            @endforeach
                                                        </div>
                                                        <p><strong>Ghi chú:</strong>
                                                            {{ $statement['statement_note'] }}
                                                        </p>
                                                        <p><strong>Phương thức:</strong>
                                                            {{ $statement['statement_payment_method_name'] }}
                                                        </p>
                                                        <p><strong>Time payment:</strong>
                                                            {{ formatFullDate($statement['updated_at']) }}</p>
                                                    </div>
                                                </div>
                                            @else
                                                <div class="card-body">
                                                    <div class="mb-3">
                                                        <label for="" class="control-label">Bằng chứng</label>
                                                        <div class="dropzone" id="statementFwdDropzone"
                                                            style="height: 80%;">
                                                        </div>
                                                        <small id="statement_images_err" class="text-danger"></small>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="label-control">Final Price</label>
                                                        <input type="text" class="form-control text-number"
                                                            value="{{ formatNumber($debits->sum('payment_price')) }}"
                                                            id="statement_amount">
                                                        <small id="statement_amount_err" class="text-danger"></small>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label class="label-control">Chuyển khoản</label>
                                                        <input type="text" class="form-control text-number"
                                                            value="{{ formatNumber($debits->sum('payment_price')) }}"
                                                            id="statement_amount_bank">
                                                        <small id="statement_amount_bank_err" class="text-danger"></small>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label class="label-control">Tiền mặt</label>
                                                        <input type="text" class="form-control text-number"
                                                            value="0" id="statement_amount_cash">
                                                        <small id="statement_amount_bank_err" class="text-danger"></small>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label for="" class="control-label">Ghi chú</label>
                                                        <textarea class="form-control" id="statement_note" rows="3"></textarea>
                                                        <small id="statement_note_err" class="text-danger"></small>
                                                    </div>
                                                    <div class="">
                                                        <strong>Phương thức thanh toán</strong>
                                                        <div class="form-check">
                                                            <input class="form-check-input" value="1" type="radio"
                                                                name="statement_payment_method" id="payment_method_bank"
                                                                checked>
                                                            <label class="form-check-label" for="payment_method_bank">
                                                                Ngân hàng
                                                            </label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input class="form-check-input" value="0" type="radio"
                                                                name="statement_payment_method" id="payment_method_direct">
                                                            <label class="form-check-label" for="payment_method_direct">
                                                                Tiền mặt
                                                            </label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input class="form-check-input" value="{{ CASH_AND_BANK }}"
                                                                type="radio" name="statement_payment_method"
                                                                id="payment_method_cash_and_bank">
                                                            <label class="form-check-label"
                                                                for="payment_method_cash_and_bank">
                                                                Tiền mặt & Ngân hàng
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="card-footer">
                                                        <button type="button" class="btn btn-primary w-100"
                                                            id="btn_payment_statement"
                                                            onclick="onPaymentStatement('{{ $statement['statement_code'] }}')">Thanh
                                                            toán</button>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="contact-list-view">
                                    @include('accounting-management.statement.ajax.table-debit', [
                                        'debits' => $debits,
                                    ])
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>


    @push('scripts')
        <!-- Dropify JS -->

        <script>
            $(".select2").select2();
        </script>
        <script src="{{ asset('js/accountant/statement/detail.js') }}"></script>
    @endpush
@endsection
