<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>Admin duyệt</th>
                <th tabindex="0" rowspan="1" colspan="1">Statement no</th>
                <th tabinDex="0" rowspan="1" colspan="1">From</th>
                <th tabinDex="0" rowspan="1" colspan="1">To</th>
                <th tabinDex="0" rowspan="1" colspan="1">Company</th>
                <th tabinDex="0" rowspan="1" colspan="1">Kế toán tạo</th>
                <th tabinDex="0" rowspan="1" colspan="1">Tổng giá</th>
                <th tabinDex="0" rowspan="1" colspan="1">Thanh toán</th>
                <th tabinDex="0" rowspan="1" colspan="1">Tiền xác nhận</th>
                <th rowspan="1" colspan="1">phương thức</th>
                <th tabinDex="0" rowspan="1" colspan="1">Trạng thái</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($statements as $key => $statement)
                <tr class="odd">
                    <td>
                        <button onclick="onActionBtnShowClick(this)"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#statement_{{ $statement['statement_id'] }}"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>
                        <span
                            class="dtr-data fw-bold text-{{ $statement['checked_payment_status'] == 0 ? 'warning' : 'success' }}">
                            {{ $statement['checked_payment_status'] == 0 ? 'Chưa duyệt' : 'Đã duyệt' }}
                        </span>
                    </td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank" disabled
                            href="{{ route('statement.detail.display', ['statement_code' => $statement['statement_code']]) }}">
                            {{ $statement['statement_code'] }}
                        </a>
                        <a href="{{ route('statement.detail.export', ['statement_code' => $statement['statement_code']]) }}"
                            target="_blank" class="btn btn-icon btn-social btn-primary ms-1"><span class="icon"><i
                                    class="fas fa-download"></i></span></a>
                    </td>
                    <td class="">
                        {{ formatDate($statement['statement_start']) }}
                    </td>
                    <td class="">
                        {{ formatDate($statement['statement_end']) }}
                    </td>
                    <td>
                        {{ $statement['customer_company'] }}
                    </td>
                    <td>
                        {{ $statement['creator_name'] }}
                    </td>
                    <td>
                        {{ number_format($statement['total_price']) }}
                    </td>
                    <td>
                        {{ number_format($statement['payment_price']) }}
                    </td>
                    <td>
                        {{ number_format($statement['statement_amount']) }}
                    </td>
                    <td>{{ $statement['statement_payment_method_name'] }}</td>
                    <td>
                        <span
                            class="dtr-data fw-bold text-{{ $statement['statement_status'] == 0 ? 'secondary' : 'success' }}">
                            {{ $statement['statement_payment_method_name'] == 0 ? 'Chờ thanh toán' : 'Đã thanh toán' }}
                        </span>
                    </td>
                </tr>
                <tr class="child collapse" id="statement_{{ $statement['statement_id'] }}">
                    <td class="child" colspan="7">
                        <ul>
                            <li class="mb-3">
                                <span class="dtr-title">Ngày tạo: </span>
                                <span class="dtr-data">{{ formatFullDate($statement['created_at']) }}</span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Bằng chứng: </span>
                                <span class="dtr-data">
                                    @foreach (onConvertStrArrImage($statement['statement_images']) as $item)
                                        <a class="p-2" href="{{ $item }}" target="_blank"><i
                                                class="fas fa-image"></i></a>
                                    @endforeach
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Ghi chú: </span>
                                <span class="dtr-data">{{ $statement['statement_note'] }}</span>
                            </li>
                            <li class="mb-3">
                                @if ($statement['statement_status'] == 0)
                                    <button class="btn btn-danger"
                                        onclick="onCancelStatement('{{ $statement['statement_code'] }}')"><i
                                            class="fas fa-times-circle me-1"></i> Hủy lệnh</button>
                                @endif
                            </li>
                        </ul>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $statements->links('components.pagination') }}
</div>
