<div class="row">
    <div class="col-sm-12 table-responsive">
        <table class="table">
            <thead class="thead-primary">
                <tr role="row">
                    <th rowspan="1" colspan="1">Date</th>
                    <th tabindex="0" rowspan="1" colspan="1">Debit no</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Số tiền</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Tổng tiền</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Trạng thái</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $colors = ['secondary', 'success', 'danger', 'warning'];
                    $icons = ['far fa-clock', 'far fa-check-circle', 'fas fa-exclamation-triangle', 'far fa-clock'];
                @endphp
                @foreach ($debits as $key => $value)
                    <tr class="odd">
                        <td>{{ formatFullDate($value['created_at']) }}</td>
                        <td>
                            <a
                                class="fw-bold text-primary"href="{{ route('debit.detail', ['debit_code' => $value->debit_no]) }}">
                                {{ $value->debit_no }}
                            </a>
                        </td>
                        <td class="align-items-center">
                            {{ formatNumber($value['total_price']) }}
                        </td>
                        <td class="align-items-center">
                            {{ formatNumber($value['total_price']) }}
                        </td>
                        <td>
                            @if (!empty($value['debit_advance_date']) && $value['debit_status'] == 0)
                                <span class="badge badge-warning">
                                    <i class="fas fa-file-invoice-dollar"></i>
                                    Đã tạm ứng
                                </span>
                            @else
                                <span class="badge badge-{{ $colors[$value['debit_status']] }}">
                                    <i class="{{ $icons[$value['debit_status']] }}"></i>
                                    {{ $value['status_label'] }}
                                </span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
