@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>List Xuất Debit</h1>
                                    </a>
                                </div>

                            </div>
                            <div class="contact-options-wrap">
                                <div class="" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Tìm kiểm nâng cao">
                                    <a class="btn btn-icon btn-flush-dark btn-rounded 
                                    flush-soft-hover no-caret d-sm-inline-block d-none"
                                        data-bs-toggle="collapse" href="#searchPlus" role="button" aria-expanded="false"
                                        aria-controls="collapseExample">
                                        <span class="icon">
                                            <span class="feather-icon">
                                                <i data-feather="search"></i>
                                            </span>
                                        </span></a>
                                </div>
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="collapse" id="searchPlus">
                                    <div class="card card-body">
                                        <div class="col-12 row">
                                            <div class="col-md-4">
                                                <label for="" class="form-lable">Từ ngày đến ngày</label>
                                                <div class="input-group">
                                                    <span class="input-affix-wrapper">
                                                        <span class="input-prefix"><span class="feather-icon"><i
                                                                    data-feather="calendar"></i></span></span>
                                                        <input class="form-control form-wth-icon" name="datetimes"
                                                            value="Aug 18,2020 - Aug 19, 2020">
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="mb-3 col-md-4">
                                                <label for="" class="form-lable">Công nợ</label>
                                                <div class="input-group">
                                                    <select class="form-control">
                                                        <option value="AK">All</option>
                                                        <option value="AK">Chưa thanh toán</option>
                                                        <option value="AK">Đã thanh toán</option>
                                                        <option value="AK">Duyệt tạm ứng</option>
                                                    </select>
                                                    <select class="form-control">
                                                        <option value="AK">Công nợ</option>
                                                        <option value="AK">Day</option>
                                                        <option value="AK">Week</option>
                                                        <option value="AK">2 Week</option>
                                                        <option value="AK">Month</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="mb-3 col-md-3 ">
                                                <label for="" class="form-lable">Tìm kiếm theo</label>
                                                <select class="form-control">
                                                    <option value="AK">Tất cả</option>
                                                    <option value="AK">ID BILL</option>
                                                    <option value="AK">HAWB</option>

                                                </select>

                                            </div>
                                            <div class="mb-3 col-1">
                                                <button class="btn btn-primary mt-4"><span><span>Fill</span><span
                                                            class="icon"><i
                                                                class="fa fa-search"></i></span></span></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="contact-list-view">
                                    <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                        <div class="row">
                                            <div class="col-7 mb-3">
                                                <div class="contact-toolbar-left">
                                                    <select
                                                        class="d-flex align-items-center w-130p form-select form-select-sm">
                                                        <option value="AK">All</option>
                                                        <option value="AK">Chưa thanh toán</option>
                                                        <option value="AK">Đã thanh toán</option>
                                                        <option value="AK">Duyệt tạm ứng</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-5 mb-3">
                                                <div class="contact-toolbar-right">
                                                    <div id="" class=""><label><input type="search"
                                                                class="form-control form-control-sm"
                                                                placeholder="Search"></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12 table-responsive">
                                                <table id="datable_1" class="table nowrap w-100 mb-5 dataTable no-footer"
                                                    aria-describedby="datable_1_info" role="grid">
                                                    <thead class="thead-primary">
                                                        <tr role="row">
                                                            <th></th>
                                                            <th rowspan="1" colspan="1">Date time</th>
                                                            <th class="sorting" tabindex="0" rowspan="1"
                                                                colspan="1">Id Bill</th>
                                                            <th class="sorting" tabinDex="0" rowspan="1"
                                                                colspan="1">N.V Scan</th>
                                                            <th class="sorting" tabinDex="0" rowspan="1"
                                                                colspan="1">Account tạo</th>
                                                            <th class="sorting" tabinDex="0" rowspan="1"
                                                                colspan="1">Company name sender</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @php
                                                            $TIME = ['DAY', 'WEEK', 'MONTH'];
                                                            $status = ['success', 'warning', 'danger'];
                                                            $status_text = [
                                                                'Đã thanh toán',
                                                                'Chờ thanh toán',
                                                                'Chưa thanh toán',
                                                            ];
                                                            $service = ['KSN-NZ', 'KSN-AU', 'KSN-EU'];
                                                        @endphp
                                                        @for ($i = 0; $i < 10; $i++)
                                                            @php
                                                                $rand = rand(0, 2);
                                                            @endphp
                                                            <tr class="odd">
                                                                <td>
                                                                    <button
                                                                        class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                                                                        data-bs-toggle="collapse"
                                                                        data-bs-target="#pickup_{{ $i }}"
                                                                        aria-expanded="false">
                                                                        <span class="icon">
                                                                            <i class="fa fa-plus"></i>
                                                                        </span>
                                                                    </button>
                                                                </td>
                                                                <td>{{ fake()->date() }}</td>
                                                                <td>
                                                                    <a
                                                                        class="fw-bold text-primary"href="{{ route('debit.detail') }}">
                                                                        {{ 'KG' . rand(10000000, 99999999) . '_' . rand(1000000000, 9999999999) }}
                                                                        <i class="fas fa-download"></i>
                                                                    </a>
                                                                </td>
                                                                <td class="align-items-center">
                                                                    {{ fake()->name() }}
                                                                </td>
                                                                <td>
                                                                    <a
                                                                        href="{{ route('debit.customer') }}">KG{{ rand(100000, 999999) }}</a>
                                                                </td>
                                                                <td>Công ty TNHH {{ fake()->name() }}</td>
                                                            </tr>
                                                            <tr class="child collapse" id="pickup_{{ $i }}">
                                                                <td class="child" colspan="5">
                                                                    <ul class="dtr-details text-dark">
                                                                        <li>
                                                                            <strong>Quốc gia: </strong>
                                                                            {{ fake()->country() }}
                                                                        </li>
                                                                        <li>
                                                                            <strong>Dịch vụ: </strong>
                                                                            {{ $service[$rand] }}
                                                                        </li>
                                                                        <li>
                                                                            <strong>Kích thước: </strong>
                                                                            {{ rand(1, 10) . 'x' . rand(1, 10) . 'x' . rand(1, 10) }}
                                                                        </li>
                                                                        <li>
                                                                            <strong>Cân nặng: </strong>
                                                                            {{ number_format(rand(1, 20)) }}kg
                                                                        </li>
                                                                        <li>
                                                                            <strong>Công nợ: </strong>
                                                                            <span
                                                                                class="text-{{ $status[$rand] }}">{{ $TIME[$rand] }}</span>
                                                                        </li>
                                                                        <li>
                                                                            <strong>Trạng thái: </strong>
                                                                            <span
                                                                                class="badge badge-sm badge-{{ $status[$rand] }}">
                                                                                <span>
                                                                                    <span class="icon"><span
                                                                                            class="feather-icon"><i
                                                                                                data-feather="package"></i></span></span>
                                                                                    {{ $status_text[$rand] }}
                                                                                </span>
                                                                            </span>
                                                                        </li>
                                                                        <li>
                                                                            <a class="btn btn-sm btn-info"><i
                                                                                    class="fa fa-image"></i></a>
                                                                        </li>
                                                                    </ul>
                                                                </td>
                                                            </tr>
                                                        @endfor
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-center mt-3">
                                            <x-pagination-demo />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')
        <!-- Dropify JS -->
        <script src="{{ asset('assets/vendors/dropify/dist/js/dropify.min.js') }}"></script>
        <script src="{{ asset('assets/dist/js/dropify-data.js') }}"></script>

        <script>
            // Hàm mở modal
            function openModal() {
                $('#rulesModal').modal('show');
            }
            $(".select2").select2();
        </script>
    @endpush
@endsection
