@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <div class="hk-pg-body py-0">
            <div class="invoiceapp-wrap">
                <nav class="invoiceapp-sidebar">
                    <div data-simplebar class="nicescroll-bar">
                        <div class="menu-content-wrap">
                            {{-- <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                                <span><span class="feather-icon"><i data-feather="award"></i></span>Thông tin công
                                    ty</span>
                            </div> --}}
                            <img src="{{ asset($company['user_logo']) }}" alt=""
                                style="width: 100%; object-fit: cover">
                            <div class="menu-gap"></div>
                            <div class="nav-header">
                                <span>Thông tin</span>
                            </div>
                            <p class="text-primary"><i class="fas fa-user"></i> Người đại diện:</p>
                            {{ $company['user_contact_name'] }}
                            <p class="text-primary"><i class="fas fa-user"></i> Mã tài khoản:</p>
                            {{ $company['user_code'] }}
                            <p class="text-primary"><i class="fas fa-phone-square"></i> Phone:</p>
                            {{ $company['user_phone'] }}
                            <p class="text-primary"><i class="fas fa-clock"></i> Ngày tạo:</p>
                            {{ formatFullDate($company['created_at']) }}
                            <div class="menu-gap"></div>
                            <div class="nav-header">
                                <span>Quản lý</span>
                            </div>
                            <div class="menu-group">
                                <ul class="nav flex-column nav-light nav-pills nav-vertical">
                                    <li class="nav-item">
                                        <a class="nav-link active" data-bs-toggle="tab" href="#tab_block_24">
                                            <span class="nav-link-text">List đơn</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </nav>
                <div class="invoiceapp-content">
                    <div class="invoiceapp-detail-wrap">
                        <header class="invoice-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h3>{{ $company['user_company_name'] }}</h3>
                                    </a>
                                </div>
                                <div class="mx-3">
                                    @if (isGetAllData())
                                        <button class="btn btn-primary" id="btn_create_debit"
                                            onclick="onCreateDebit()">Khởi
                                            tạo
                                            debit</button>
                                    @endif
                                </div>
                            </div>
                            <div class="invoice-options-wrap">
                                <div class="">
                                </div>
                                <div class="v-separator d-lg-inline-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover hk-navbar-togglable d-lg-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-bs-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="btn-icon-wrap">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                            <div class="hk-sidebar-togglable"></div>
                        </header>
                        <div class="invoice-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="invoice-list-view">
                                    <div class="tab-content">
                                        <div class="tab-pane fade show active" id="tab_block_24">

                                            <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                                <div class="row justify-content-between">
                                                    <div class="col-sm-4 mb-3">
                                                        <label class="form-lable">Từ ngày đến ngày</label>
                                                        <input class="form-control form-wth-icon" name="datetimes">
                                                    </div>
                                                    <div class="mb-3 col-sm-4">
                                                        <label class="form-lable">Dịch vụ</label>
                                                        <select class="form-control select2 select2-multiple"
                                                            id="shipment_service_id" multiple>
                                                            @foreach ($services as $key => $service)
                                                                <option value="{{ $service['service_id'] }}">
                                                                    {{ $service['service_name'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="mb-3 col-sm-4">
                                                        <label class="form-lable">Trạng thái</label>
                                                        <select class="form-control" id="company_shipment_status">
                                                            <option value=""> Import, Export</option>
                                                            <option value="{{ SHIPMENT_STATUS_IMPORTED }}"> Import</option>
                                                            <option value="{{ SHIPMENT_STATUS_EXPORED }}"> Export</option>
                                                        </select>
                                                    </div>
                                                    <div class="mb-3 col-sm-4">
                                                        <label class="form-lable">Thanh toán</label>
                                                        <select class="form-control" id="company_shipment_payment">
                                                            <option value="">Tất cả</option>
                                                            <option value="1">Chưa thanh toán</option>
                                                            <option value="2">Duyệt tạm ứng</option>
                                                            <option value="3">Đã thanh toán</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-sm-4 mb-4">
                                                        <label class="form-lable">Tìm kiếm</label>
                                                        <input type="search" class="form-control" id="keywords"
                                                            placeholder="Nhấn 'enter' để tìm kiếm">
                                                    </div>
                                                    <div class="col mb-3">

                                                    </div>
                                                </div>
                                                <div class="row mt-3">
                                                    <div class="" id="content-list"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Page Body -->

        
    </div>
@endsection

@push('scripts')
    <script>
        let pub_company_id = @json($company->user_id);
        console.log(pub_company_id);
    </script>
    <script src="{{ asset('js/accountant/debit/company.js') }}"></script>
@endpush
