@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper">
        <div class="container-xxl">
            <!-- Page Header -->
            <div class="hk-pg-header pg-header-wth-tab pt-7">
                <div class="d-flex">
                    <div class="d-flex flex-wrap justify-content-between flex-1">
                        <div class="mb-lg-0 mb-2 me-8">
                            <h5 class="pg-title">Đơn hàng: 3298005104</h5>
                        </div>
                    </div>
                </div>
                <ul class="nav nav-tabs nav-icon nav-light">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#tab_block_12">
                            <span class="nav-icon-wrap"><span class="feather-icon"><i data-feather="info"></i></span></span>
                            <span class="nav-link-text">Thông tin lô hàng</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#tab_block_22">
                            <span class="nav-icon-wrap"><span class="feather-icon"><i data-feather="box"></i></span></span>
                            <span class="nav-link-text">Thông tin kiện hàng</span>
                        </a>
                    </li>
                </ul>
            </div>
            <!-- /Page Header -->

            <!-- Page Body -->
            <div class="hk-pg-body">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="tab_block_12">
                        <div class="mb-3">
                            <div class="card">
                                <div class="card-header bg-primary text-white h5">Thông tin người gửi</div>
                                <div class="card-body">
                                    <div class="callout callout-info">
                                        <p>- Công ty: <b>CONG TY TNHH THE GIOI EXPRESS</b></p>
                                        <p>- Tên người gửi: <b>THE GIOI EXPRESS</b></p>
                                        <p>- Số Điện Thoại: 0908916198</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="card">
                                <div class="card-header bg-primary text-white h5">Thông tin dịch vụ</div>
                                <div class="card-body">
                                    <div class="callout callout-info">
                                        <p>- Dịch vụ: <b>KSN-NZ</b></p>
                                        <p>- Brand: HCM</p>
                                        <p>- Dịch vụ chữ ký người nhận: Không</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="card">
                                <div class="card-header bg-primary text-white h5">Thông tin người nhận</div>
                                <div class="card-body">
                                    <div class="callout callout-info">
                                        <p>- Công ty: <b>Tien Nguyen</b></p>
                                        <p>- Tên người nhận: <b>Tien Nguyen</b></p>
                                        <p>- Số Điện Thoại: +64 021418041</p>
                                        <p>- Địa chỉ: 36 Foxlaw Street, Auckland</p>
                                        <p>- State: <b>Auckland</b></p>
                                        <p>- Post Code <b>: 2105</b></p>
                                        <p>- Quốc Gia <b>: New Zealand</b></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="tab_block_22">
                        <div class="mb-3">
                            <div class="row">
                                <div class="col-sm-12 table-responsive">
                                    <table id="datable_1" class="table nowrap w-100 mb-5 dataTable no-footer"
                                        aria-describedby="datable_1_info" role="grid">
                                        <thead class="thead-dark">
                                            <tr class="" role="row">
                                                <th rowspan="1" colspan="1"></th>
                                                <th class="sorting fw-bold" tabindex="0" rowspan="1"
                                                    colspan="1">Mã
                                                    HAWB</th>
                                                <th class="sorting fw-bold" tabinDex="0" rowspan="1"
                                                    colspan="1">
                                                    Type</th>
                                                <th class="sorting fw-bold" tabindex="0" rowspan="1"
                                                    colspan="1">
                                                    Weight(kg)
                                                </th>
                                                <th class="fw-bold" tabindex="0" rowspan="1" colspan="1">
                                                    CONVERTED  WEIGHT</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $vehicals = ['Xe máy', 'Bán tải', 'Xe tải'];
                                                $status = ['success', 'warning', 'danger'];
                                                $texts = ['Đã pickup', 'Đang đi lấy', 'Đang chờ'];
                                                $address = ['HCM', 'Hà Nội', 'Đà Nẵng'];
                                            @endphp
                                            @for ($i = 0; $i < 5; $i++)
                                                @php
                                                    $rand = rand(0, 2);
                                                @endphp
                                                <tr class="odd">
                                                    <td>
                                                        <button
                                                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                                                            data-bs-toggle="collapse"
                                                            data-bs-target="#pickup_{{ $i }}"
                                                            aria-expanded="false">
                                                            <span class="icon">
                                                                <i class="fa fa-plus"></i>
                                                            </span>
                                                        </button>
                                                    </td>
                                                    <td><a
                                                            class="fw-bold text-primary" href="#">
                                                            {{ rand(1000000000, 9999999999) }}<i
                                                                class="ms-3 fas fa-map-marker-alt"></i>
                                                        </a>
                                                    </td>
                                                    <td>Carton</td>
                                                    <td class="fw-bold">{{ rand(1, 100) }}kg</td>
                                                    @php
                                                        $a = rand(1, 100);
                                                        $b = rand(1, 100);
                                                        $c = rand(1, 100);
                                                        $d = ($a * $b * $c) / 6000;
                                                    @endphp
                                                    <td>{{ $a }}(<strong>L</strong>)x{{ $a }}(<strong>W</strong>)x{{ $a }}(<strong>H</strong>)/6000={{ round($d, 2) }}
                                                    </td>

                                                </tr>
                                                <tr class="child collapse" id="pickup_{{ $i }}">
                                                    <td class="child" colspan="5">
                                                        <ul data-dtr-index="0" class="dtr-details">
                                                            <li data-dtr-index="5" data-dt-row="0" data-dt-column="5">
                                                                <span class="dtr-title">CHARGED WEIGHT</span> <span
                                                                    class="dtr-data">3 kg</span>
                                                            </li>
                                                            <li data-dtr-index="6" data-dt-row="0" data-dt-column="6">
                                                                <span class="dtr-title">STATUS</span> <span
                                                                    class="dtr-data"><small
                                                                        class="badge badge-secondary"><i
                                                                            class="far fa-clock"></i> Create
                                                                        Bill</small></span>
                                                            </li>
                                                            <li data-dtr-index="7" data-dt-row="0" data-dt-column="7">
                                                                <span class="dtr-title">TRACKING CODE</span> <span
                                                                    class="dtr-data"></span>
                                                            </li>
                                                            <li data-dtr-index="8" data-dt-row="0" data-dt-column="8">
                                                                <span class="dtr-title">Nhân Viên Xử Lý</span> <span
                                                                    class="dtr-data"></span>
                                                            </li>
                                                        </ul>
                                                    </td>
                                                </tr>
                                            @endfor
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center mt-3">
                                <x-pagination-demo />
                            </div>
                        </div>
                        <div class="row">
                            <div class="card">
                                <div class="card-header bg-primary text-white h5">Chỉnh sửa danh sách phụ thu</div>
                                <div class="card-body">
                                    <div class="col-12 row">
                                        <div class="col-md-3 mb-3">
                                            <label for="" class="form-label">Length</label>
                                            <input type="number" class="form-control" value="24">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="" class="form-label">Width</label>
                                            <input type="number" class="form-control" value="22">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="" class="form-label">Height</label>
                                            <input type="number" class="form-control" value="14">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="" class="form-label">Weight</label>
                                            <input type="number" class="form-control" value="2.5">
                                        </div>
                                        <div class="mb-3">
                                            <label for="" class="form-label">Khai hàng</label>
                                            <div class="col row">
                                                <div class="col-md-8">
                                                    <select class="form-control select2" data-placeholder="danh mục">
                                                        <option value="CT">Connecticut</option>
                                                        <option value="DE">Delaware</option>
                                                        <option value="FL">Florida</option>
                                                        <option value="GA">Georgia</option>
                                                        <option value="IN">Indiana</option>
                                                        <option value="ME">Maine</option>
                                                        <option value="MD">Maryland</option>
                                                        <option value="MA">Massachusetts</option>
                                                        <option value="MI">Michigan</option>
                                                        <option value="NH">New Hampshire</option>
                                                        <option value="NJ">New Jersey</option>
                                                        <option value="NY">New York</option>
                                                        <option value="NC">North Carolina</option>
                                                        <option value="OH">Ohio</option>
                                                        <option value="PA">Pennsylvania</option>
                                                        <option value="RI">Rhode Island</option>
                                                        <option value="SC">South Carolina</option>
                                                        <option value="VT">Vermont</option>
                                                        <option value="VA">Virginia</option>
                                                        <option value="WV">West Virginia</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-3 mb-3">
                                                    <input type="number" value="20" class="form-control">
                                                </div>
                                                <div class="col-md-1 mb-3">
                                                    <button class="btn btn-danger btn-sm">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-success btn-sm">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                                <div class="card-footer justify-content-end">
                                    <button class="btn btn-primary">
                                        <span>
                                            <span class="icon"><i class="fa fa-save"></i></span>
                                            <span>Cập nhật</span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header bg-primary text-white h5">Chỉnh sửa danh sách phụ thu ngoài hệ
                                    thống</div>
                                <div class="card-body">
                                    <div class="col-12 row">
                                        <div class="col-md-6 mb-3">
                                            <label for="" class="form-label">Nhập tên mặt hàng phụ thu</label>
                                            <input type="text" class="form-control" placeholder="Nhập tên mặt hàng">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="" class="form-label">Nhập số lượng</label>
                                            <input type="number" class="form-control">
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="" class="form-label">Nhập đơn giá/số lượng</label>
                                            <input type="number" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer justify-content-end ">
                                    <button class="btn btn-primary">
                                        <span>
                                            <span class="icon"><i class="fa fa-plus"></i></span>
                                            <span>Thêm phụ thu</span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Page Body -->
        </div>
    </div>
    @push('scripts')
        <script src="{{ asset('assets/vendors/dropzone/dist/dropzone.min.js') }}"></script>
        <script>
            $(".select2").select2();
        </script>
    @endpush
@endsection
