@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper">
        <div class="px-3">
            <!-- Page Header -->
            <div class="hk-pg-header pg-header-wth-tab pt-7">
                <div class="d-flex">
                    <div class="d-flex flex-wrap justify-content-between flex-1">
                        <div class="mb-lg-0 mb-2 me-8">
                            <h5 class="pg-title">DEBIT NO: {{ $debit->debit_no }}</h5>
                        </div>
                        @if (onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user_debit->position_id))
                            <div class="">
                                <ul class="nav nav-light nav-pills">
                                    <li class="nav-item">
                                        <a class="nav-link active" data-bs-toggle="pill" href="#tab_block_13">
                                            <span class="nav-link-text">Thanh toán</span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-bs-toggle="pill" href="#tab_block_23">
                                            <span class="nav-link-text">Danh sách shipment</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        @endif
                    </div>
                </div>

            </div>
            <!-- /Page Header -->
            <!-- Page Body -->
            <div class="hk-pg-body">
                @if (onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user_debit->position_id))
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="tab_block_13">
                            <div class="row">
                                <div class="col-sm-8">
                                    <div class="card">
                                        <div class="hk-ribbon-type-1 ribbon-wth-icon overhead-start">
                                            <span><span class="feather-icon"><i data-feather="award"></i></span>Thông tin
                                                thanh
                                                toán</span>
                                        </div>
                                        <div class="card-body mt-4">
                                            {{-- @include('template.info-payment-debit') --}}
                                            <div class="ck-content">
                                                {!! $content !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="mb-5">
                                        <div class="card">
                                            <div class="hk-ribbon-type-1 ribbon-wth-icon overhead-start">
                                                <span><span class="feather-icon"><i data-feather="award"></i></span>Thanhh
                                                    toán</span>
                                            </div>

                                            <div class="card-body">
                                                <div class="title title-xs title-wth-divider text-primary text-uppercase">
                                                    <span>
                                                        Thông tin debit
                                                    </span>
                                                </div>
                                                <p><strong>Mã khách hàng:</strong> {{ $user_debit->user_code }}</p>
                                                <p><strong>Tổng đơn:</strong> {{ $debit->total_sm }}</p>
                                                <p><strong>Tổng tiền:</strong> {{ number_format($debit->total_price) }}
                                                </p>
                                                <p><strong>Vat:</strong> {{ number_format($debit->total_vat) }}</p>
                                                <div
                                                    class="title title-xs title-wth-divider text-primary text-uppercase mt-4">
                                                    <span>
                                                        Trạng thái
                                                    </span>
                                                </div>
                                                @if ($debit->debit_status == 1)
                                                    <div class="alert alert-success mt-3">
                                                        <p><span class="me-1 fs-5"><i
                                                                    class="far fa-check-circle"></i></span>Đã thanh toán
                                                        </p>
                                                        <div class="d-flex flex-row">
                                                            @foreach (onConvertStrArrImage($debit->debit_images) as $item)
                                                                <a class="p-2" href="{{ $item }}"
                                                                    target="_blank"><i class="fas fa-image"></i></a>
                                                            @endforeach
                                                        </div>
                                                        <p><strong>Số tiền thanh toán:</strong>
                                                            {{ formatNumber($debit['debit_payment_amount']) }}</p>
                                                        <p><strong>Phương thức:</strong>
                                                            {{ $debit->method_label }}</p>
                                                        <p><strong>Time payment:</strong>
                                                            {{ formatFullDate($debit->debit_payment_date) }}</p>
                                                        <p><strong>Ghi chú:</strong>
                                                            {{ $debit['debit_note'] }}</p>
                                                    </div>
                                                @else
                                                    @if ($debit->debit_status == 3)
                                                        <div class="alert alert-warning mt-3">
                                                            <p><span class="me-1 fs-5"><i
                                                                        class="far fa-check-circle"></i></span> Đã
                                                                gửi bằng chứng thanh toán chờ duyệt lệnh!</p>
                                                            <div class="d-flex flex-row">
                                                                @foreach (onConvertStrArrImage($debit->debit_images) as $item)
                                                                    <a class="p-2" href="{{ $item }}"
                                                                        target="_blank"><i class="fas fa-image"></i></a>
                                                                @endforeach
                                                            </div>
                                                            <p><strong>Phương thức:</strong>
                                                                {{ $debit->method_label }}</p>
                                                            <p><strong>Time payment:</strong>
                                                                {{ formatFullDate($debit->debit_advance_date) }}</p>
                                                        </div>
                                                        @if (isGetAllData())
                                                            <div class="mb-3">
                                                                <label for="" class="form-label">Xác nhận số
                                                                    tiền</label>
                                                                <input type="text" class="form-control text-number"
                                                                    id="debit_payment_amount"
                                                                    value="{{ formatNumber($debit->total_price) }}">
                                                                <small id="debit_payment_amount_err"
                                                                    class="text-danger"></small>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="" class="form-label">Chuyển
                                                                    khoản</label>
                                                                <input type="text" class="form-control text-number"
                                                                    id="debit_payment_bank_amount"
                                                                    value="{{ formatNumber($debit->total_price) }}">
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="" class="form-label">Tiền mặt</label>
                                                                <input type="text" class="form-control text-number"
                                                                    id="debit_payment_cash_amount" value="0">
                                                            </div>
                                                            <div class="card-footer">
                                                                <button type="button" class="btn btn-primary"
                                                                    id="btn_confirm_payment_debit"
                                                                    onclick="onConfirmPaymentDebit()">Xác nhận</button>
                                                            </div>
                                                        @endif
                                                    @else
                                                        <div class="mb-3">
                                                            <label for="" class="control-label">Bằng chứng</label>
                                                            <div class="dropzone" id="debitFwdDropzone"
                                                                style="height: 80%;">
                                                            </div>
                                                            <small id="images_debit_err" class="text-danger"></small>
                                                        </div>
                                                        @if (isGetAllData())
                                                            <div class="mb-3">
                                                                <label for="" class="form-label">Xác nhận số
                                                                    tiền</label>
                                                                <input type="text" class="form-control text-number"
                                                                    id="debit_payment_amount"
                                                                    value="{{ formatNumber($debit->total_price) }}">
                                                                <small id="debit_payment_amount_err"
                                                                    class="text-danger"></small>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="" class="form-label">Chuyển
                                                                    khoản</label>
                                                                <input type="text" class="form-control text-number"
                                                                    id="debit_payment_bank_amount"
                                                                    value="{{ formatNumber($debit->total_price) }}">
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="" class="form-label">Tiền mặt</label>
                                                                <input type="text" class="form-control text-number"
                                                                    id="debit_payment_cash_amount" value="0">
                                                            </div>
                                                        @endif
                                                        <div class="mb-3">
                                                            <label for="" class="control-label">Ghi chú</label>
                                                            <textarea class="form-control" id="note_debit" rows="3"></textarea>
                                                            <small id="note_debit_err" class="text-danger"></small>
                                                        </div>
                                                        <div class="">
                                                            <strong>Phương thức thanh toán</strong>
                                                            <div class="form-check">
                                                                <input class="form-check-input" value="{{BANK}}"
                                                                    type="radio" name="debit_payment_method"
                                                                    id="payment_method_bank" checked>
                                                                <label class="form-check-label" for="payment_method_bank">
                                                                    Ngân hàng
                                                                </label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input class="form-check-input" value="{{CASH}}"
                                                                    type="radio" name="debit_payment_method"
                                                                    id="payment_method_direct">
                                                                <label class="form-check-label"
                                                                    for="payment_method_direct">
                                                                    Tiền mặt
                                                                </label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input class="form-check-input" value="{{CASH_AND_BANK}}"
                                                                    type="radio" name="debit_payment_method"
                                                                    id="payment_method_cash_and_bank">
                                                                <label class="form-check-label"
                                                                    for="payment_method_cash_and_bank">
                                                                    Tiền mặt & Ngân hàng
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <div class="card-footer">
                                                            <button type="button" class="btn btn-primary"
                                                                id="btn_payment_debit" onclick="onPaymentDebit()">Thanh
                                                                toán</button>
                                                        </div>
                                                    @endif

                                                @endif
                                            </div>

                                        </div>
                                    </div>
                                    <div class="">
                                        @if ($debit->debit_status != 1)
                                            <div class="card">
                                                <div class="hk-ribbon-type-1 ribbon-wth-icon overhead-start">
                                                    <span><span class="feather-icon"><i
                                                                data-feather="award"></i></span>Tạm
                                                        ứng</span>
                                                </div>
                                                <div class="card-body mt-4">
                                                    @if (!empty($debit->debit_advance_images) && isset($debit->debit_advance_date))
                                                        <div class="alert alert-success mt-3">
                                                            <p><span class="me-1 fs-5"><i
                                                                        class="far fa-check-circle"></i></span>Đã
                                                                tạm
                                                                ứng!</p>
                                                            <p><strong>Số tiền:</strong>
                                                                {{ number_format($debit->debit_advance_amount) }}</p>
                                                            <p><strong>Bằng chứng: </strong>
                                                                @foreach (onConvertStrArrImage($debit->debit_advance_images) as $item)
                                                                    <a class="" href="{{ $item }}"
                                                                        target="_blank"><i class="fas fa-image"></i></a>
                                                                @endforeach
                                                            </p>

                                                            <p><strong>Tạo lúc:</strong>
                                                                {{ formatFullDate($debit->debit_advance_date) }}</p>
                                                        </div>
                                                    @elseif(isGetAllData())
                                                        <div class="mb-3">
                                                            <label for="" class="control-label">Bằng chứng</label>
                                                            <div class="dropzone" id="debitAdvanceDropzone"
                                                                style="height: 80%;">
                                                            </div>
                                                            <small id="images_advance_err" class="text-danger"></small>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="" class="form-label">Số tiền</label>
                                                            <input type="text" class="form-control text-number"
                                                                id="debit_advance_amount" value="0">
                                                            <small id="debit_advance_amount_err"
                                                                class="text-danger"></small>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="" class="control-label">Ghi chú</label>
                                                            <textarea class="form-control" id="note_advance" rows="3"></textarea>
                                                            <small id="note_advance_err" class="text-danger"></small>
                                                        </div>
                                                        <div class="card-footer">
                                                            <button type="button" class="btn btn-warning"
                                                                id="btn_advance_debit" onclick="onAdvanceDebit()">Tạm
                                                                ứng</button>
                                                        </div>
                                                    @endif

                                                </div>
                                            </div>
                                        @endif

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="tab_block_23">
                            <div class="">
                                <div class="d-flex justify-content-end mb-3">
                                    <div class="col-sm-9">
                                        Danh sách các shipment đươc tạo
                                    </div>
                                    <div class="col-sm-3">
                                        <input type="search" id="keywords" class="form-control form-control-sm"
                                            placeholder="Search">
                                    </div>
                                </div>
                                <div class="mb-3" id="content">

                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="">
                        <div class="d-flex justify-content-end mb-3">
                            <div class="col-sm-9">
                                Danh sách các shipment đươc tạo
                            </div>
                            <div class="col-sm-3">
                                <input type="search" id="keywords" class="form-control form-control-sm"
                                    placeholder="Search">
                            </div>
                        </div>
                        <div class="mb-3" id="content">

                        </div>
                    </div>
                @endif
            </div>
            <!-- /Page Body -->
        </div>
    </div>
    @push('scripts')
        <script>
            let pub_debit_id = `{{ $debit->debit_id }}`
            let pub_debit_no = `{{ $debit->debit_no }}`
        </script>
        <script src="{{ asset('js/debit/detail.js') }}"></script>
    @endpush
@endsection
