@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper">
        <div class="container-xxl">
            <!-- Page Header -->
            <div class="hk-pg-header pg-header-wth-tab pt-7">
                <div class="d-flex">
                    <div class="d-flex flex-wrap justify-content-between align-items-center flex-1 m-1">
                        <div class="rounded">
                            <img style="height: 100px; width: auto; object-fit: cover;"
                                src="{{ empty($user->user_logo) ? '' : asset($user->user_logo) }}" alt="">
                        </div>
                        <div class="mb-lg-0 mb-2 me-8">
                            <h5 class="pg-title">{{ $user->user_company_name }}</h5>
                            <p>Mã khách hàng: {{ $user->user_code }}</p>
                        </div>
                    </div>
                </div>

            </div>
            <!-- /Page Header -->

            <div class="row mt-3">
                <div class="col-xl-3 col-md-6">
                    <div class="card shadow card-border text-center">
                        <div class="card-body">
                            <h5 class="app-name">Contact</h5>
                            <div class="app-cat">{{ $user->user_phone }}</div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card shadow card-border text-center">
                        <div class="card-body">

                            <h5 class="app-name">Mã số thuế</h5>
                            <div class="app-cat">{{ $user->user_tax_code }}</div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card shadow card-border text-center">
                        <div class="card-body">

                            <h5 class="app-name">Total package</h5>
                            <div class="app-cat">{{ $packages->total_package }}</div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card shadow card-border text-center">
                        <div class="card-body">

                            <h5 class="app-name">Total Weight</h5>
                            <div class="app-cat">{{ $packages->total_weight }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Page Body -->
            <div class="hk-pg-body">
                <div class="tab-content">

                    <div class="">
                        <div class="card card-body">
                            <div class="row">
                                <div class="col-sm-4 mb-3">
                                    <label class="form-lable">Từ ngày đến ngày</label>
                                    <div class="input-group">
                                        <span class="input-affix-wrapper">
                                            <span class="input-prefix">
                                                <span class="feather-icon">
                                                    <i data-feather="calendar"></i>
                                                </span>
                                            </span>
                                            <input class="form-control form-wth-icon" name="shipment_daterange">
                                        </span>
                                    </div>
                                </div>
                                <div class="mb-3 col-sm-4">
                                    <label class="form-lable">Chi nhánh</label>
                                    <select class="form-control select2" name="shipment_branch_id">
                                        <option value="">All</option>
                                        @foreach ($branchs as $key => $branch)
                                            <option value="{{ $branch['branch_id'] }}">
                                                {{ $branch['branch_name'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="mb-3 col-sm-4">
                                    <label class="form-lable">Trạng thái</label>
                                    <select class="form-control select2" name="shipment_status">
                                        <option value="">All</option>
                                        @foreach ($shipment_status as $key => $status)
                                            <option value="{{ $key }}">{{ $status }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="mb-3 col-sm-8">
                                    <label class="form-lable">Tìm kiếm</label>
                                    <input type="text" class="form-control" name="shipment_keywords" id="keywords"
                                        placeholder="Nhập nội dung bạn muốn tìm kiếm">
                                </div>
                                <div class="mb-3 col-sm-4">
                                    <label class="form-lable">Tìm kiếm theo</label>
                                    <select class="form-control select2" name="filter_by">
                                        @foreach ($shipment_filter_by as $key => $filter_by)
                                            <option value="{{ $key }}">{{ $filter_by }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3" id="content">

                        </div>
                    </div>
                </div>
            </div>
            <!-- /Page Body -->
        </div>
    </div>
    @push('scripts')
        <script>
            $(".select2").select2();
            let pub_user_id = `{{ $user->user_id }}`
        </script>
        <script src="{{ asset('js/debit/customer.js') }}"></script>
    @endpush
@endsection
