<div class="row">
    <div class="col-sm-12 table-responsive">
        <table id="datable_1" class="table w-100 mb-5 no-footer">
            <thead class="thead-primary">
                <tr role="row">
                    <th tabindex="0" rowspan="1" colspan="1">Date </th>
                    <th tabindex="0">
                        <input class="form-check-input" type="checkbox" id="is_check_all" onclick="onCheckAll()"
                            {{ $is_check_all ? 'checked' : '' }}>
                        <label class="text-white" for="is_check_all">ID Bill</label>
                    </th>
                    <th colspan="1">Đất nước</th>
                    <th>Dịch vụ</th>
                    <th class="text-white" colspan="1">
                        Người nhận</th>
                    <th class="text-white" colspan="1">
                        Packages</th>
                    <th class="text-white" colspan="1">
                        Mawb</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($shipments as $key => $shipment)
                    <tr class="odd">
                        <td>
                            {{ formatFullDate($shipment['created_at']) }}
                        </td>
                        <td>
                            <div class="form-check">
                                @if (
                                    !isset($shipment['shipment_debit_id']) &&
                                        $shipment['shipment_payment_status'] != 1 &&
                                        !onCheckIsEpacket($shipment['shipment_service_id'], $shipment['service']['promotion_flg']))
                                    <input class="form-check-input" type="checkbox"
                                        {{ in_array($shipment['shipment_id'], $choosed_id) ? 'checked' : '' }}
                                        onclick="onChooseShipment({{ $shipment['shipment_id'] }})"
                                        id="choose_bill_{{ $shipment['shipment_code'] }}">
                                @elseif($shipment['shipment_payment_status'] == 1)
                                    <span class="badge badge-primary">Đã thanh toán</span>
                                @elseif ($shipment['shipment_payment_step'] == 0 && isset($shipment['shipment_debit_id']))
                                    <span class="badge badge-warning">Chờ thanh toán</span>
                                @elseif (
                                    $shipment['shipment_payment_step'] > 0 &&
                                        $shipment['shipment_payment_step'] < 3 &&
                                        $shipment['shipment_payment_status'] == 0)
                                    <span class="badge badge-warning">Duyệt tạm ứng</span>
                                @elseif ($shipment['shipment_payment_step'] > 2 && $shipment['shipment_payment_status'] == 0)
                                    <span class="badge badge-success">Chờ xác nhận</span>
                                @endif
                                <label class="form-check-label fw-bold text-primary"
                                    for="choose_bill_{{ $shipment['shipment_code'] }}">
                                    {{ $shipment['shipment_code'] }}
                                </label>
                            </div>
                        </td>
                        <td>{{ $shipment['country']['country_name'] }}</td>
                        <td>
                            @include('components.badges-promotion-name', [
                                'service_id' => $shipment['shipment_service_id'],
                                'promotion_flg' => $shipment['service']['promotion_flg'],
                            ])
                            {{ $shipment['service']['service_name'] }}
                        </td>
                        <td class="align-items-center">
                            {{ $shipment['receiver_contact_name'] }}
                        </td>
                        @php
                            $packages = getPackagesAndMawbByShipment($shipment['shipment_id']);
                            $colors = ['secondary', 'info', 'success', 'danger', 'danger'];
                        @endphp
                        <td>
                            @foreach ($packages as $package)
                                <div class="mb-1">
                                    <a href="{{ route('debit.fwd.imported-goods.detail', ['package_code' => $package['package_code']]) }}"
                                        target="_blank">
                                        <i class="fas fa-external-link-alt text-primary mr-2"></i>
                                        {{ $package['package_code'] }} - {{ $package['package_charged_weight'] }} kg
                                    </a>
                                    <small class="badge badge-{{ $colors[$package['package_status']] }}">
                                        <i class="far fa-clock"></i>
                                        {{ $package['package_status_name'] }}
                                    </small>
                                </div>
                                <br>
                            @endforeach
                        </td>
                        <td>
                            @foreach ($packages as $package)
                                @if (isset($package['awb_code']))
                                    <a href="{{ route('mawb.bill-shipment', ['awb_code' => $package['awb_code']]) }}"
                                        type="" class="">{{ $package['awb_code'] }}</a><br>
                                @endif
                            @endforeach
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-3">
    {{ $shipments->links('components.pagination') }}
</div>
