<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>Ngày</th>
                <th>ID Bill</th>
                <th>Người tạo</th>
                <th>Công ty gửi</th>
                <th>Người nhận</th>
                <th>Quốc gia</th>
                <th>Dịch vụ</th>
                <th>Số kiện</th>
                <th>Cân nặng</th>
                <th>Trạng thái</th>
                <th>Debit</th>
            </tr>
        </thead>
        <tbody>
            @php
                $colors = ['secondary', 'info', 'success', 'danger'];
            @endphp
            @foreach ($shipments as $key => $shipment)
                <tr class="odd">
                    <td>
                        <button id="btn_shipment_{{ $key }}" onclick="onActionBtnShowClick(this)"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#shipment_{{ $key }}"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>{{ formatFullDate($shipment['created_at']) }}</td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="{{ route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']]) }}">
                            {{ $shipment['shipment_code'] }}
                        </a>
                    </td>
                    <td>
                        <a href="{{ route('debit.fwd.detail.sm-fwd', ['company_code' => $shipment['user_code']]) }}">
                            {{ $shipment['user_contact_name'] }} [{{ $shipment['user_code'] }}]
                        </a>
                    </td>
                    <td>
                        {{ $shipment['sender_company_name'] }}
                    </td>
                    <td>
                        {{ $shipment['receiver_contact_name'] }}
                    </td>
                    <td>{{ $shipment['country']['country_name'] ?? '' }}</td>
                    <td>{{ $shipment['service']['service_name'] ?? '' }}</td>
                    <td>
                        {{ collect($shipment['packages'])->count('package_id') }}
                    </td>
                    <td>
                        {{ collect($shipment['packages'])->sum('package_weight') }}
                    </td>
                    <td>
                        @if ($shipment['shipment_payment_status'] == 1)
                            <span class="dtr-data fw-bold text-success">
                                Đã thanh toán
                            </span>
                        @else
                            @if ($shipment['shipment_payment_step'] > 1)
                                <span class="dtr-data fw-bold text-warning">
                                    Duyệt tạm ứng
                                </span>
                            @else
                                <span class="dtr-data fw-bold text-danger">
                                    Chưa thanh toàn
                                </span>
                            @endif
                        @endif
                    </td>
                    <td>
                        @if (!empty($shipment['debit']['debit_no']))
                            <a class="fw-bold" href="{{ route('debit.detail', ['debit_code' => $shipment['debit']['debit_no']]) }}">
                                {{ $shipment['debit']['debit_no'] ?? '' }}</a>
                        @endif
                        
                    <td>
                </tr>
                <tr class="child collapse" id="shipment_{{ $key }}">
                    <td class="child" colspan="7">
                        <ul>
                            <li class="mb-3">
                                <span class="dtr-title">Trạng thái: </span>
                                <span class="dtr-data">
                                    <small class="badge badge-{{ $colors[$shipment['shipment_status']] }}">
                                        {{ $shipment['shipment_status_name'] }}
                                    </small>
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Ref: </span>
                                <span class="dtr-data">{{ $shipment['shipment_reference_code'] }}</span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Tổng tiền: </span>
                                <span class="dtr-data">
                                    {{ formatNumber($shipment['shipment_final_amount']) }} VND
                                </span>
                            </li>
                            <li>
                                <span class="dtr-title"></span>
                                <span class="dtr-data">
                                    <a href="{{ route('shipments.edit.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                        type="button" class="btn btn-warning btn-sm"><i class="far fa-edit"></i></a>
                                </span>
                            </li>
                        </ul>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $shipments->links('components.pagination') }}
</div>
