<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th>Import scan time</th>
                <th>ID Bill</th>
                <th>N.V Scan</th>
                <th>Account tạo</th>
                <th>Company name sender</th>
                <th>Quốc gia</th>
                <th>Dịch vụ</th>
                <th>Kích thước</th>
                <th>Cân nặng</th>
                <th>Status</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @php
                $colors = ['secondary', 'info', 'success', 'danger'];
            @endphp
            @foreach ($importedGoods as $key => $goods)
                <tr class="odd">
                    <td>{{ $goods['created_at'] }}</td>
                    <td>
                        <a href="{{ route('debit.fwd.imported-goods.detail', ['package_code' => $goods['package_code']]) }}"
                            target="_blank">
                            <i class="fas fa-external-link-alt text-primary mr-2"></i>
                            {{ $goods['package_code'] }}
                        </a>
                    </td>
                    <td>{{ $goods['scan_by_name'] }}</td>
                    <td>
                        @if (onCheckPositionAccount(SETTING_FWD_ACCOUNT, $goods['creator_position_id']))
                            <a
                                href="{{ route('debit.fwd.detail.sm-fwd', ['company_code' => $goods['creator_code']]) }}">{{ $goods['creator_code'] }}</a>
                        @else
                            {{ $goods['creator_code'] }}
                        @endif
                        @include('components.badges-position-name', [
                            'position_id' => $goods['creator_position_id'],
                        ])
                    </td>
                    <td>{{ $goods['sender_company_name'] }}</td>
                    <td>{{ $goods['country_name'] }}</td>
                    <td>{{ $goods['service_name'] }}</td>
                    <td>
                        {{ $goods['length'] }} x
                        {{ $goods['width'] }} x
                        {{ $goods['height'] }}
                    </td>
                    <td>{{ $goods['weight'] }} kg</td>
                    <td class="dtr-data fw-bold text-{{ $goods['status'] == 0 ? 'danger' : 'success' }}">
                        {{ $goods['status'] == 0 ? 'Chưa thanh toán' : 'Đã thanh toán' }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $importedGoods->links('components.pagination') }}
</div>
