  <div class="row">
      <div class="col-sm-12 table-responsive">
          <table id="datable_1" class="table nowrap w-100 mb-5 dataTable no-footer" aria-describedby="datable_1_info"
              role="grid">
              <thead class="thead-dark">
                  <tr class="" role="row">
                      <th class=" fw-bold">Date</th>
                      <th class=" fw-bold">Kg bill no</th>
                      <th class=" fw-bold">Tracking</th>
                      <th class="fw-bold">Service</th>
                      <th class=" fw-bold">Destination</th>
                      <th class="fw-bold">Type</th>
                      <th class="fw-bold">Package</th>
                      <th class="fw-bold">DESCRIPTION OF GOODS</th>
                      <th class="fw-bold">Freight Price</th>
                      <th class="fw-bold">Extra Price</th>
                      <th class="fw-bold">VAT</th>
                      <th class="fw-bold">Total</th>
                  </tr>
              </thead>
              <tbody>
                  @foreach ($shipments as $key => $value)
                      @php
                          $charged_weight = 0;
                          $converted_weight = 0;
                          $extra_price = 0;
                          $colors = ['secondary', 'info', 'success', 'danger', 'danger'];
                      @endphp
                      <tr class="odd">
                          <td> {{ formatFullDate($value['created_at']) }}</td>
                          <td>
                              <a class="fw-bold text-primary" target="_blank"
                                  href="{{ route('shipments.detail.show', ['shipment_code' => $value->shipment_code]) }}">
                                  {{ $value->shipment_code }}
                              </a>
                          </td>
                          <td class=""></td>
                          <td class="">{{ $value->service['service_name'] }}</td>
                          <td>{{ $value->country['country_name'] }}</td>
                          <td>PACK</td>
                          <td>
                              @foreach ($value['packages'] as $item)
                                  @php
                                      $charged_weight += $item['package_weight'];
                                      $converted_weight += $item['package_converted_weight'];
                                  @endphp
                                  <p class="dtr-data text-info mb-1">{{ $item['package_code'] }} -
                                      {{ $item['package_charged_weight'] }} kg
                                      <small class="badge badge-{{ $colors[$item['package_status']] }}">
                                          <i class="far fa-clock"></i>
                                          {{ $item['package_status_name'] }}
                                      </small>
                                  </p>
                              @endforeach
                          </td>
                          <td>
                              @if (hasSurchargeFeeService($value['shipment_id']))
                                  <p>Phí dân cư: {{ formatNumber($value['shipment_amount_residential']) }}</p>
                                  <p>Phí cao điểm: {{ formatNumber($value['shipment_amount_peak']) }}</p>
                              @endif
                              @foreach (getDataSurchargeGoodPackagesByShipment($value['shipment_id']) as $sp_good)
                                  <p class="dtr-data">
                                      {{ $sp_good['surcharge_goods_name'] ?? $sp_good['external_surcharge_name'] }}:
                                      {{ $sp_good['count'] }} x {{ $sp_good['price'] }}
                                      = {{ formatNumber($sp_good['count'] * $sp_good['price']) }}</p>
                                  @php
                                      $extra_price += $sp_good['count'] * $sp_good['price'];
                                  @endphp
                              @endforeach
                          </td>

                          <td>
                              {{ formatNumber($value['shipment_amount_original']) }}
                          </td>
                          <td>
                              {{ formatNumber($extra_price + $value['shipment_amount_residential'] + $value['shipment_amount_peak']) }}
                          </td>
                          <td>
                              {{ formatNumber($value['shipment_amount_vat']) }}
                          </td>
                          <td>
                              {{ formatNumber($value['shipment_final_amount']) }}
                          </td>
                      </tr>
                  @endforeach
              </tbody>
          </table>
      </div>
  </div>
  <div class="d-flex justify-content-center mt-3">
      {{ $shipments->links('components.pagination') }}
  </div>
