<div class="row">
    <div class="col-sm-12 table-responsive">
        <table id="datable_1" class="table nowrap w-100 mb-5 dataTable no-footer" aria-describedby="datable_1_info"
            role="grid">
            <thead class="thead-primary">
                <tr role="row">
                    <th>Admin duyệt</th>
                    <th rowspan="1" colspan="1">Date time</th>
                    <th tabindex="0" rowspan="1" colspan="1">Debit no</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Company</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Người tạo</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Loại</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Trạng thái</th>
                    {{-- <th tabinDex="0" rowspan="1" colspan="1">Tạm ứng</th> --}}
                    <th tabinDex="0" rowspan="1" colspan="1">Mã khách hàng</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Tổng Vat</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Tổng FSC</th>
                    <th tabinDex="0" rowspan="1" colspan="1">Tổng tiền</th>
                    @if (!$is_cancel)
                        <th tabinDex="0" rowspan="1" colspan="1">Tổng thu khách</th>
                    @endif
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @php
                    $colors = ['secondary', 'success', 'danger', 'warning'];
                    $icons = ['far fa-clock', 'far fa-check-circle', 'fas fa-exclamation-triangle', 'far fa-clock'];
                @endphp
                @foreach ($debits as $key => $value)
                    <tr class="odd">
                        <td>
                            <span
                                class="dtr-data fw-bold text-{{ $value['checked_payment_status'] == 0 ? 'warning' : 'success' }}">
                                {{ $value['checked_payment_status'] == 0 ? 'Chưa duyệt' : 'Đã duyệt' }}
                            </span>
                            @if (!isset($value['checked_payment']['checked']) && $value['checked_payment_status'] == 1)
                                <span>
                                    <i title="Đơn duyệt thông qua Statement"
                                        class="fas fa-exclamation-circle text-warning"></i>
                                </span>
                            @endif
                        </td>
                        <td>{{ $value->created_at }}</td>
                        <td>
                            <a
                                class="fw-bold text-primary"href="{{ route('debit.detail', ['debit_code' => $value->debit_no]) }}">
                                {{ $value->debit_no }}
                            </a>
                            @if ($is_cancel)
                                <a href="{{ route('debit.fwd.export.bill.debit', ['debit_no' => $value->debit_no]) }}"
                                    class="btn btn-icon btn-social btn-primary ms-1"><span class="icon"><i
                                            class="fas fa-download"></i></span></a>
                            @endif
                        </td>
                        <td>{{ $value->customer_company }}</td>
                        <td class="align-items-center">
                            {{ $value->creator_name }}
                        </td>
                        <td class="fw-bold text-primary">{{ $value->type_label }}</td>
                        <td class="align-items-center">
                            @if (!empty($value->debit_advance_date) && $value['debit_status'] != 1)
                                <span class="badge badge-warning">
                                    <i class="fas fa-file-invoice-dollar"></i>
                                    Đã tạm ứng
                                </span>
                            @else
                                <span class="badge badge-{{ $colors[$value['debit_status']] }}">
                                    <i class="{{ $icons[$value->debit_status] }}"></i>
                                    {{ $value['status_label'] }}
                                </span>
                            @endif
                        </td>
                        <td class="align-items-center fw-bold">
                            @if ($is_cancel)
                                <a
                                    href="{{ route('debit.fwd.detail.sm-fwd', ['company_code' => $value->customer_code]) }}">{{ $value->customer_code }}</a>
                            @else
                                <a
                                    href="{{ route('debit.customer', ['user_code' => $value->customer_code]) }}">{{ $value->customer_code }}</a>
                            @endif
                            <span
                                class="text-danger fw-bold">[{{ getPriceListUser($value['customer_id'])['price_list_title'] ?? 'Chưa xét bảng giá' }}]</span>
                        </td>
                        <td class="align-items-center">
                            {{ number_format($value->total_vat) }}
                        </td>
                        <td class="align-items-center">
                            {{ number_format($value->total_fsc) }} [{{ $value['debit_fsc'] }}%]
                        </td>
                        <td class="align-items-center">
                            {{ number_format($value->total_price) }}
                        </td>
                        @if (!$is_cancel)
                            <td class="align-items-center">
                                {{ number_format($value['total_amount_customer']) }}
                            </td>
                        @endif
                        <td>
                            @if ($value->customer_id === auth()->id() && $value->debit_status != 1 && !$is_cancel)
                                <button type="button" class="btn btn-success btn-floating"
                                    onclick="onPaymentDebit('{{ $value->debit_no }}')">
                                    <i class="fas fa-file-invoice-dollar"></i>
                                    Thanh toán
                                </button>
                            @endif
                            @if (isGetAllData() && !$is_cancel && $value['total_no_confirm'] > 0)
                                <button onclick="onAcountantConfimInDebit('{{ $value['debit_id'] }}')"
                                    class="btn btn-icon btn-success btn-animated btn-lg"><span class="icon"><i
                                            class="far fa-check-circle"></i></span></button>
                            @endif
                            @if (isGetAllData() && $is_cancel && $value->debit_status != 1)
                                <button type="button" class="btn btn-danger btn-floating"
                                    onclick="onCancelDebit({{ $value->debit_id }})">
                                    <i class="fas fa-times-circle"></i>
                                    Hủy lệnh
                            @endif
                            @if ($value->debit_status == 1)
                                @foreach (onConvertStrArrImage($value->debit_images) as $item)
                                    <a class="p-2" href="{{ $item }}" target="_blank"><i
                                            class="fas fa-image"></i></a>
                                @endforeach
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-3">
    {{ $debits->links('components.pagination') }}
</div>
