@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper">
        <div class="mx-3">
            <!-- Page Header -->
            <div class="hk-pg-header pg-header-wth-tab pt-7">
                <div class="d-flex">
                    <div class="d-flex flex-wrap justify-content-between flex-1">
                        <div class="mb-lg-0 mb-2 me-8">
                            <h5 class="pg-title">CREDIT NO: {{ $credit['credit_no'] }}</h5>
                            <a href="{{ route('credit.detail.packages-export', ['credit_id' => $credit['credit_id']]) }}"
                                target="_blank">
                                <i class="fa fa-download"></i> Tải xuống Excel
                            </a>
                        </div>
                    </div>
                </div>

            </div>
            <!-- /Page Header -->

            <!-- Page Body -->
            <div class="hk-pg-body">
                @if ($credit['credit_status'] == 2)
                    <div class="alert alert-warning mt-3">
                        <p><span class="me-1 fs-3 fw-bold"><i class="fas fa-clock"></i></span>Đang xử lý</p>
                        <p><strong>Hình ảnh:</strong></p>
                        <div class="d-flex flex-row">
                            @foreach (onConvertStrArrImage($credit['credit_images']) as $item)
                                <a class="p-2" href="{{ $item }}" target="_blank"><i
                                        class="fas fa-image"></i></a>
                            @endforeach
                        </div>
                        <p><strong>Cấn trừ:</strong>
                            {{ $credit['credit_note'] }}</p>
                        <p><strong>Ngày cập nhật:</strong>
                            {{ formatFullDate($credit['created_at']) }}</p>
                    </div>
                @endif
                <div class="tab-content">
                    @if ($credit['credit_status'] != 1)
                        <div class="accordion accordion-icon mb-3" id="accordionIcon">
                            @if ($credit['credit_status'] == 0)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="icon-headingOne">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#icon-collapseOne" aria-expanded="true"
                                            aria-controls="icon-collapseOne">
                                            <div class="d-flex align-items-center"><i class="fas fa-box-open me-3"></i>
                                                <span>THÊM PACKAGE</span>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="icon-collapseOne" class="accordion-collapse collapse show"
                                        aria-labelledby="headingOne" data-bs-parent="#accordionIcon">
                                        <div class="accordion-body">
                                            <form class="" id="form-add-package">

                                                <div class="mb-3">
                                                    <label>ID HAWB</label>
                                                    <input type="text" class="form-control" id="package_code"
                                                        placeholder="Nhập ID HAWB" value="">
                                                    <small id="package_code_err" class="text-danger"></small>
                                                </div>
                                                <div class="mb-3">
                                                    <label>GOODS COMPENSATION ( Số tiền bồi thường )</label>
                                                    <input type="text" class="form-control text-number"
                                                        id="goods_compensation" placeholder="Nhập số tiền cần bồi thường"
                                                        value="">
                                                    <small id="goods_compensation_err" class="text-danger"></small>
                                                </div>
                                                <div class="mb-3">
                                                    <label>Ghi chú</label>
                                                    <input type="text" class="form-control" id="credit_item_note"
                                                        placeholder="Nhập ghi chú" value="">
                                                    <small id="credit_item_note_err" class="text-danger"></small>
                                                </div>
                                                <div class="text-end">
                                                    <button class="btn btn-primary" id="btn_add_package">
                                                        <span>
                                                            <span class="icon"><i class="fa fa-plus"></i></span>
                                                            <span>Thêm kiện hàng vào credit</span>
                                                        </span>
                                                    </button>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="icon-headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#icon-collapseTwo" aria-expanded="false"
                                        aria-controls="icon-collapseTwo">
                                        <div class="d-flex align-items-center"><i
                                                class="fas fa-file-invoice-dollar me-3"></i>
                                            <span>CẬP NHẬT THANH TOÁN</span>
                                        </div>
                                    </button>
                                </h2>
                                <div id="icon-collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                                    data-bs-parent="#accordionIcon">
                                    <div class="accordion-body">
                                        <div id="uphinh">
                                            <label for="">Tải lên bằng chứng thanh toán </label>
                                            <div class="dropzone" id="paymentCreditDropzone"></div>
                                            <small class="text-danger" id="images_payment_err"></small>
                                        </div>
                                        <div class="col-md-12">
                                            <strong>Trạng thái</strong>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="credit_status"
                                                    id="credit_status_finish" value="1" checked>
                                                <label class="form-check-label" for="credit_status_finish">
                                                    Đã thanh toán
                                                </label>
                                            </div>
                                            @if ($credit['credit_status'] != 2)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="credit_status"
                                                        id="credit_status_pending" value="2">
                                                    <label class="form-check-label" for="credit_status_pending">
                                                        Đang xử lý
                                                    </label>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="text-end mt-3">
                                            <button class="btn btn-primary" onclick="onPaymentCredit()">
                                                <span>
                                                    <span class="icon"><i class="fa fa-plus"></i></span>
                                                    <span>Cập nhật thanh thanh toán</span>
                                                </span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="icon-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#icon-collapseThree" aria-expanded="false"
                                        aria-controls="icon-collapseThree">
                                        <div class="d-flex align-items-center"><i class="fas fa-minus-square me-3"></i>
                                            <span>CẤN TRỪ THANH TOÁN :</span>
                                        </div>
                                    </button>
                                </h2>
                                <div id="icon-collapseThree" class="accordion-collapse collapse"
                                    aria-labelledby="headingThree" data-bs-parent="#accordionIcon">
                                    <div class="accordion-body">
                                        <div class="">
                                            <div id="">
                                                <label for="">Tải lên bằng chứng thanh toán </label>
                                                <div class="dropzone" id="paymentCreditDropzone2"></div>
                                                <small class="text-danger" id="images_payment2_err"></small>
                                            </div>
                                            <div class="mb-3">
                                                <label>( DEBIT OR STATMENT )</label>
                                                <input type="text" class="form-control" id="credit_note"
                                                    placeholder="Nhập DEBIT OR STATMENT cấn trừ" value="">
                                            </div>
                                            <div class="mb-3">
                                                <strong>Trạng thái</strong>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="credit_status2"
                                                        id="credit_status_finish2" value="1" checked>
                                                    <label class="form-check-label" for="credit_status_finish2">
                                                        Đã thanh toán
                                                    </label>
                                                </div>
                                                @if ($credit['credit_status'] != 2)
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="radio"
                                                            name="credit_status2" id="credit_status_pending2"
                                                            value="2">
                                                        <label class="form-check-label" for="credit_status_pending2">
                                                            Đang xử lý
                                                        </label>
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="text-end">
                                                <button class="btn btn-primary" onclick="onPaymentDebitOrStatment()">
                                                    <span>
                                                        <span class="icon"><i class="fa fa-plus"></i></span>
                                                        <span>Cập nhật</span>
                                                    </span>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-success mt-3">
                            <p><span class="me-1 fs-5"><i class="far fa-check-circle"></i></span>Đã thanh toán
                            </p>
                            <p><strong>Hình ảnh:</strong></p>
                            <div class="d-flex flex-row">
                                @foreach (onConvertStrArrImage($credit['credit_images']) as $item)
                                    <a class="p-2" href="{{ $item }}" target="_blank"><i
                                            class="fas fa-image"></i></a>
                                @endforeach
                            </div>
                            <p><strong>Cấn trừ:</strong>
                                {{ $credit['credit_note'] }}</p>
                            <p><strong>Ngày cập nhật:</strong>
                                {{ formatFullDate($credit['created_at']) }}</p>
                        </div>
                    @endif


                    <div class="">
                        <hr>
                        <div class="d-flex justify-content-end mb-3">
                            <div class="col-3">
                                <input type="search" id="keywords" class="form-control form-control-sm"
                                    placeholder="nhấn 'Enter' để tìm kiếm">
                            </div>
                        </div>
                        <div class="mb-3" id="content">

                        </div>
                    </div>
                </div>
            </div>
            <!-- /Page Body -->
        </div>
    </div>
    @push('scripts')
        <script src="{{ asset('assets/vendors/dropify/dist/js/dropify.min.js') }}"></script>
        <script src="{{ asset('assets/dist/js/dropify-data.js') }}"></script>
        <script>
            Dropzone.autoDiscover = false;
            const pub_credit_id = @json($credit['credit_id']);
        </script>
        <script src="{{ asset('js/accountant/credit/detail.js') }}"></script>
    @endpush
@endsection
