<div class="table-responsive">
    <table id="datable_1" class="table nowrap w-100 mb-5 dataTable no-footer" aria-describedby="datable_1_info"
        role="grid">
        <thead class="thead-primary">
            <tr class="" role="row">
                <th></th>
                <th class="fw-bold" tabinDex="0">
                    bill no</th>
                <th class="fw-bold" tabindex="0">
                    Package code</th>
                <th class="fw-bold" tabindex="0">
                    Tracking</th>
                <th class="sorting fw-bold" tabindex="0">
                    Giá trị gói
                </th>
                <th class="fw-bold" tabindex="0">
                    Bồi thường</th>
                <th class="fw-bold" tabindex="0">
                    Tổng giá trị
                </th>
            </tr>
        </thead>
        <tbody>
            @foreach ($packages as $key => $package)
                <tr class="odd">
                    <td>
                        <button class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#credit_package_{{ $key }}"
                            aria-expanded="false" onclick="onActionBtnShowClick(this)">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>{{ $package['shipment_code'] }}</td>
                    <td>{{ $package['package_code'] }}</td>
                    <td>{{ $package['package_tracking_code'] }}</td>
                    <td class="">
                        @if ($credit['credit_status'] == 0)
                            <div class="input-group mb-3">
                                <input type="text" class="form-control text-number"
                                    id="value_package_{{ $package['credit_item_id'] }}"
                                    value="{{ number_format($package['value_package']) }}">
                                <button class="btn btn-primary" type="button"
                                    onclick="onUpdateValuePackage({{ $package['credit_item_id'] }})">
                                    Update
                                </button>
                            </div>
                        @else
                            {{ number_format($package['value_package']) }}
                        @endif
                    </td>
                    <td> {{ number_format($package['goods_compensation']) }}</td>
                    <td> {{ number_format($package['goods_compensation'] + $package['value_package']) }}</td>
                </tr>
                <tr class="child collapse" id="credit_package_{{ $key }}">
                    <td class="child" colspan="5">
                        <ul class="dtr-details">
                            <li>
                                <span class="dtr-title">SERVICE: </span>
                                <span class="dtr-data">
                                    {{ $package['service_name'] }}
                                </span>
                            </li>
                            <li>
                                <span class="dtr-title">DESTINATION:
                                </span> <span class="dtr-data">
                                    {{ $package['country_name'] }}
                                </span>
                            </li>
                            <li>
                                <span class="dtr-title">NOTE: </span>
                                <span class="dtr-data">{{ $package['credit_item_note'] }}</span>
                            </li>
                            @if ($credit['credit_status'] == 0)
                                <li>
                                    <button class="btn btn-danger btn-sm"
                                        onclick="onRemovePackage({{ $package['credit_item_id'] }})">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </li>
                            @endif

                        </ul>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $packages->links('components.pagination') }}
</div>
