<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th rowspan="1" colspan="1">Date time</th>
                <th tabindex="0" rowspan="1" colspan="1">Credit no</th>
                <th tabinDex="0" rowspan="1" colspan="1">Mã Account</th>
                <th tabinDex="0" rowspan="1" colspan="1">Tên liên hệ</th>
                <th tabinDex="0" rowspan="1" colspan="1">Company</th>
                <th tabinDex="0" rowspan="1" colspan="1">Kế toán tạo</th>
                <th tabinDex="0" rowspan="1" colspan="1">Total</th>
                <th tabinDex="0" rowspan="1" colspan="1">Trạng thái</th>
                <th tabinDex="0" rowspan="1" colspan="1">IMG[note]</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($credits as $key => $credit)
                <tr class="odd">
                    <td>{{ formatFullDate($credit['created_at']) }}</td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank" disabled
                            href="{{ route('credit.detail.show', ['credit_no' => $credit['credit_no']]) }}">
                            {{ $credit['credit_no'] }}
                        </a>
                        <a data-bs-toggle="tooltip" data-bs-placement="left" title="Tải bill"
                            href="{{ route('credit.detail.packages-export', ['credit_id' => $credit['credit_id']]) }}"
                            target="_blank" class="btn btn-icon btn-social btn-primary ms-1"><span class="icon"><i
                                    class="fas fa-download"></i></span></a>
                    </td>
                    <td class="">
                        {{ $credit['customer_code'] }}
                    </td>
                    <td class="">
                        {{ $credit['customer_contact_name'] }}
                    </td>
                    <td>
                        {{ $credit['customer_company_name'] }}
                    </td>
                    <td>
                        {{ $credit['creater_contact_name'] }}
                    </td>
                    <td>
                        {{ number_format($credit['credit_amount']) }}
                    </td>
                    <td>
                        <span class="dtr-data fw-bold text-{{ $credit['credit_status_color'] }}">
                            {{ $credit['credit_status_name'] }}
                        </span>
                    </td>
                    <td>
                        @foreach (onConvertStrArrImage($credit['credit_images']) as $item)
                            <a class="p-2" href="{{ $item }}" target="_blank"><i
                                    class="fas fa-image"></i></a>
                        @endforeach
                        <p>{{ $credit['credit_note'] }}</p>

                    </td>
                    <td>
                        @if ($credit['credit_status'] != 1)
                            <button data-bs-toggle="tooltip" data-bs-placement="left" title="Cập nhật bằng chứng"
                                data-bs-target="#modalUpBillCredit" class="btn btn-info mb-1"
                                onclick="onUpBillCredit('{{ $credit['credit_no'] }}', {{ $credit['credit_status'] }})">
                                <i class="fas fa-file-invoice-dollar"></i>
                            </button>
                        @endif
                        @if ($credit['credit_status'] == 0)
                            <button data-bs-toggle="tooltip" data-bs-placement="left" title="Hủy lệnh"
                                class="btn btn-danger mb-1" onclick="onCancelCredit('{{ $credit['credit_no'] }}')"><i
                                    class="fas fa-times-circle"></i> </button>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $credits->links('components.pagination') }}
</div>
