@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content mx-3 p-0">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>Quản lý chi tiêu</h1>
                                    </a>
                                </div>
                                <div class="ms-3">

                                </div>
                            </div>
                            <div class="h-100 d-md-flex d-none">
                                <ul class="nav nav-line nav-tabs nav-icon nav-light flex-shrink-0 px-2" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <a class="d-flex align-items-center h-100 nav-link active" data-bs-toggle="tab"
                                            href="#content_list" aria-selected="true" role="tab">
                                            <span class="nav-icon-wrap">
                                                <i class="fas fa-clipboard-list"></i>
                                            </span>
                                            <span class="nav-link-text">Danh sách</span>
                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="d-flex align-items-center h-100 nav-link" data-bs-toggle="tab"
                                            href="#content_chart" aria-selected="false" role="tab" tabindex="-1">
                                            <span class="nav-icon-wrap">
                                                <i class="fas fa-chart-pie"></i>
                                            </span>
                                            <span class="nav-link-text">Thống kê</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="contact-options-wrap">
                                <div class="">
                                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalFinancial">
                                        Thêm thu/chi</button>
                                </div>

                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="content_list">
                                        <div class="">
                                            <div class="" id="">
                                                <div class="card card-body">
                                                    <div class="col-12 row">
                                                        <div class="col-md-3">
                                                            <label for="" class="form-lable">Từ ngày đến
                                                                ngày</label>
                                                            <div class="input-group">
                                                                <span class="input-affix-wrapper">
                                                                    <span class="input-prefix"><span class="feather-icon"><i
                                                                                data-feather="calendar"></i></span></span>
                                                                    <input class="form-control form-wth-icon"
                                                                        name="datetimes">
                                                                </span>
                                                            </div>
                                                        </div>
                                                        {{-- <div class="col-sm-9 row">
                                                            
                                                        </div> --}}
                                                        <div class="mb-3 col-sm-3">
                                                            <label for="" class="form-lable">Thu/chi</label>
                                                            <select class="form-select doc-form-control doc-select"
                                                                id="financial_type">
                                                                <option value="">Tất cả</option>
                                                                <option value="0">Thu</option>
                                                                <option value="1">Chi</option>
                                                            </select>
                                                        </div>
                                                        <div class="mb-3 col-sm-3">
                                                            <label for="" class="form-lable">Phương thức</label>
                                                            <div class="input-group">
                                                                <select class="form-select doc-form-control doc-select"
                                                                    id="financial_method">
                                                                    <option value="">Tất cả</option>
                                                                    <option value="0">Tiền mặt</option>
                                                                    <option value="1">Chuyển khoản</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="mb-3 col-sm-3">
                                                            <label for="" class="form-lable">Phân loại</label>
                                                            <div class="input-group">
                                                                <select class="form-select doc-form-control doc-select"
                                                                    id="financial_is_salary_select">
                                                                    <option value="">Tất cả</option>
                                                                    <option value="0">Bên ngoài</option>
                                                                    <option value="1">Trả lương</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="mb-3 col-sm-3">
                                                            <label for="form-label">Chi nhánh</label>
                                                            <select class="form-select doc-form-control doc-select"
                                                                id="financial_branch">
                                                                <option value="">Tất cả</option>
                                                                @foreach ($branchs as $key => $branch)
                                                                    <option value="{{ $branch->branch_id }}">
                                                                        {{ $branch->branch_name }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="col-sm-3 mb-3">
                                                            <label for="" class="form-label">Xuất báo
                                                                cáo</label>
                                                            <button class="btn btn-primary w-100" id="btn_export_financial" onclick="exportExcelFinancial()">
                                                                <i class="fas fa-file-excel"></i></button>
                                                        </div>
                                                        <div class="col-sm-6 mb-3">
                                                            <label for="" class="form-label">Tìm kiếm</label>
                                                            <div class="input-group">
                                                                <span class="input-affix-wrapper">
                                                                    <input type="text" class="form-control"
                                                                        placeholder="Tìm kiếm..." id="keywords">
                                                                    <span class="input-suffix"><i
                                                                            class="fa fa-search"></i></span>
                                                                </span>
                                                                <button class="btn btn-success"
                                                                    onclick="fetchData()"><span><span class="icon"><i
                                                                                class="fa fa-search"></i></span></span></button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="contact-list-view">
                                                <div class="row">
                                                    <div class="col-sm-12 table-responsive" id="content">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="content_chart">
                                        <div class="card card-body">
                                            <div id="column_chart_1"></div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="card card-body">
                                                    <p class="text-danger">
                                                        <span class="fw-bold">Tiền chi(Bank): </span>
                                                        <span id="total_chi_bank"></span>
                                                    </p>
                                                    <p class="text-danger">
                                                        <span class="fw-bold">Tiền chi(Cash): </span>
                                                        <span id="total_chi_cash"></span>
                                                    </p>
                                                    <p class="text-danger">
                                                        <span class="fw-bold">Tổng tiền chi: </span>
                                                        <span id="total_chi"></span>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="card card-body">
                                                    <div class="text-primary">
                                                        <p class="text-primary">
                                                            <span class="fw-bold">Tiền nhận(Cash): </span>
                                                            <span id="total_thu_cash"></span>
                                                        </p>
                                                        <p class="text-primary">
                                                            <span class="fw-bold">Quỹ tiền mặt còn lại: </span>
                                                            <span id="total_cash_con"></span>
                                                        </p>
                                                        <p class="text-warining">
                                                            <span class="fw-bold">Tiền chi lương: </span>
                                                            <span id="total_salary"></span>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>

    <div class="modal fade" id="modalFinancial" tabindex="-1" aria-labelledby="modalFinancialLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h1 class="modal-title text-white fs-5" id="modalFinancialLabel">Khởi tạo thu/chi</h1>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="" class="form-label">Chi nhánh</label>
                        <select class="form-control" id="financial_branch_id">
                            @foreach ($branchs as $key => $branch)
                                <option value="{{ $branch->branch_id }}">{{ $branch->branch_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <strong>Phân loại</strong>
                        <div class="form-check">
                            <input class="form-check-input" value="0" type="radio" name="financial_type"
                                id="financial_type_income" checked>
                            <label class="form-check-label" for="financial_type_income">
                                Thu tiền
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" value="1" type="radio" name="financial_type"
                                id="financial_type_expend">
                            <label class="form-check-label" for="financial_type_expend">
                                Chi tiền
                            </label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="" class="form-label">Đối tượng thu/chi</label>
                        <input type="text" class="form-control" value=""
                            placeholder="Nhập tên đối tượng thu/chi" id="financial_customer_name">
                        <small id="financial_customer_name_err" class="text-danger"></small>
                    </div>
                    <div class="mb-3">
                        <label for="" class="form-label">Số tiền</label>
                        <input type="text" class="form-control text-number" value="0" id="financial_amount">
                        <small id="financial_amount_err" class="text-danger"></small>
                    </div>
                    <div class="mb-3">
                        <strong>Phương thức</strong>
                        <div class="form-check">
                            <input class="form-check-input" value="1" type="radio" name="financial_method"
                                id="financial_method_bank" checked>
                            <label class="form-check-label" for="financial_method_bank">
                                Ngân hàng
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" value="0" type="radio" name="financial_method"
                                id="financial_method_direct">
                            <label class="form-check-label" for="financial_method_direct">
                                Tiền mặt
                            </label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="" class="control-label">Bằng chứng (<span class="text-danger">*Chuyển khoản
                                cần phải có hình ảnh</span>)</label>
                        <div class="dropzone" id="financialImages" style="height: 80%;"></div>
                        <div class="" id="modal_content_imgs"></div>
                        <small id="financial_images_err" class="text-danger"></small>

                    </div>
                    <div class="mb-3">
                        <label for="" class="control-label">Nội dung</label>
                        <textarea class="form-control" id="financial_content" placeholder="Nhập nội dung chuyển khoản..."
                            rows="3"></textarea>
                        <small id="financial_content_err" class="text-danger"></small>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="" id="financial_is_salary">
                            <label class="form-check-label" for="financial_is_salary">
                                Thu/chi dành cho lương
                            </label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" onclick="onCreateOrUpdateFinancial()">Xác
                        nhận</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Button trigger modal -->

    @push('scripts')
        <script src="{{ asset('assets/vendors/xlsx/dist/xlsx.full.min.js') }}"></script>
        <script src="{{ asset('assets/vendors/file-saver/dist/FileSaver.min.js') }}"></script>

        <script src="{{ asset('assets/vendors/apexcharts/dist/apexcharts.min.js') }}"></script>
        <script src="{{ asset('assets/dist/js/column-chart-init.js') }}"></script>
        <script>
            $(".select2").select2({
                dropdownParent: $('#modalFinancial')
            });
        </script>
        <script src="{{ asset('js/accountant/financial/index.js') }}"></script>
    @endpush
@endsection
