<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>Mã</th>
                <th>Ngày</th>
                <th>Chi nhánh</th>
                <th>Số tiền</th>
                <th>Đối tác</th>
                <th>Phướng thức</th>
                <th>Ghi chú</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($financials as $key => $financial)
                <tr class="odd {{ $financial['financial_type'] == 0 ? 'table-success' : '' }}">
                    <td>
                        <button id="btn_financial_{{ $key }}" onclick="onActionBtnShowClick(this)"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#financial_{{ $key }}"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>
                        {{ $financial['financial_code'] }}
                    </td>
                    <td>{{ formatFullDate($financial['created_at']) }}</td>
                    <td class="">
                        {{ $financial['branch_name'] }}
                    </td>
                    <td>
                        {{ number_format($financial['financial_amount']) }}
                    </td>
                    <td>
                        {{ $financial['financial_customer_name'] }}
                    </td>
                    <td>
                        <span class="text-primary fw-bold">{{ $financial['financial_type_label'] }}</span>
                        ({{ $financial['financial_method_label'] }})
                    </td>
                    <td>
                        {{ $financial['financial_content'] }}
                    </td>
                    <td>
                        <button class="btn btn-icon btn-success"
                            onclick="onShowModalFinancial('{{ $financial['financial_code'] }}')">
                            <span class="icon"><i class="fas fa-edit"></i></span>
                        </button>
                        <button class="btn btn-icon btn-danger"
                            onclick="onDeleteFinancial('{{ $financial['financial_code'] }}')">
                            <span class="icon"><i class="fas fa-trash"></i></span>
                        </button>
                    </td>
                </tr>
                <tr class="child collapse" id="financial_{{ $key }}">
                    <td class="child" colspan="7">
                        <ul>
                            <li class="mb-3">
                                <span class="dtr-title">Người tạo: </span>
                                <span class="dtr-data">
                                    {{ $financial['user_contact_name'] }}
                                    [<span class="text-primary fw-bold">{{ $financial['user_code'] }}</span>]
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Phiếu chi: </span>
                                <span class="dtr-data">
                                    @foreach (onConvertStrArrImage($financial['financial_images']) as $image)
                                        <a href="{{ $image }}" target="_blank" class="m-1"><i
                                                class="fas fa-image"></i></a>
                                    @endforeach
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Chi lương: </span>
                                <span class="dtr-data">
                                    <i
                                        class="ms-1 {{ $financial['financial_is_salary'] == 0 ? 'far fa-square' : 'far fa-check-square' }}"></i>
                                </span>
                            </li>

                        </ul>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $financials->links('components.pagination') }}
</div>
