<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Mã</th>
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Ngày</th>
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Chi nhánh</th>
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Số tiền</th>
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Đối tác</th>
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Phướng thức</th>
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Chi lương</th>
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Người tạo</th>
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Ghi chú</th>
                <th style="background-color: #007D88; font-weight: bold; color: #FFF">Phiếu chi</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data_excel as $key => $financial)
                <tr class="odd">
                    <td>
                        {{ $financial['financial_code'] }}
                    </td>
                    <td>{{ formatFullDate($financial['created_at']) }}</td>
                    <td class="">
                        {{ $financial['branch_name'] }}
                    </td>
                    <td>
                        {{ number_format($financial['financial_amount']) }}
                    </td>
                    <td>
                        {{ $financial['financial_customer_name'] }}
                    </td>
                    <td>
                        <span class="text-primary fw-bold">{{ $financial['financial_type_label'] }}</span>
                        ({{ $financial['financial_method_label'] }})
                    </td>
                    <td>
                        {{ $financial['financial_is_salary'] == 0 ? ' NO' : 'YES' }}
                    </td>
                    <td>
                        {{ $financial['user_contact_name'] }}
                        [<span class="text-primary fw-bold">{{ $financial['user_code'] }}</span>]
                    </td>
                    <td>
                        {{ $financial['financial_content'] }}
                    </td>
                    <td>
                        @foreach (onConvertStrArrImage($financial['financial_images']) as $image)
                            <a href="{{ $image }}" target="_blank" class="m-1">{{ url($image) }}</a>
                            <br>
                        @endforeach
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
