function formatNumberThousand(number) {
    number = parseFloat(number);
    var numberAsString = number.toString();
    var count = 0;
    if (numberAsString.indexOf('.') !== -1) {
        count = numberAsString.substring(numberAsString.indexOf('.') + 1).length;
    }
    return number.toLocaleString(undefined, { minimumFractionDigits: count, maximumFractionDigits: count });
}

function formatNumber(number) {
    var endsWithDot = number[number.length - 1] === '.';
    number = number.replace(/[^0-9.]/g, '');
    number = parseFloat(number);
    if (!isNaN(number)) {
        var numberAsString = number.toString();
        var count = 0;
        if (numberAsString.indexOf('.') !== -1) {
            count = numberAsString.substring(numberAsString.indexOf('.') + 1).length;
        }
        var formattedNumber = number.toLocaleString('en-US', {
            minimumFractionDigits: count,
            maximumFractionDigits: count
        });
        if (endsWithDot && count === 0) {
            formattedNumber += '.';
        }
        return formattedNumber;
    }
    return 0;
}

function formatNumber2(number, currency_decimals = 2) {
    number = parseFloat(number);
    if (isNaN(number)) return '0.00'; // Kiểm tra nếu không phải số

    return number.toLocaleString(undefined, { minimumFractionDigits: currency_decimals, maximumFractionDigits: currency_decimals });
}

function convertStringToNumber(value) {
    if (value) {
        value = value.toString();
        return parseFloat(value.replace(/,(?=\d)|,(?=\.)/g, ''));
    }
    return 0;
}

function convertStringToNumber2(value) {
    if (value) {
        str = value;
        return num2 = Number(str.replace(/,/g, ""));
    }
    return 0;
}

function setData(object, key, value) {
    var keys = key.split('.');
    var currentObject = object;

    for (var i = 0; i < keys.length; i++) {
        if (i === keys.length - 1) {
            if (currentObject[keys[i]] !== undefined) {
                currentObject[keys[i]] = value;
            } else {
                currentObject[keys[i]] = value;
            }
        } else {
            if (currentObject[keys[i]] === undefined || currentObject[keys[i]] === null) {
                currentObject[keys[i]] = {};
            }
            currentObject = currentObject[keys[i]];
        }
    }

    return object;
}

function getData(data, path, defaultValue = null) {
    const parts = path.split('.');
    const result = parts.reduce((obj, key) => {
        if (obj !== undefined && obj !== null) {
            return obj[key];
        } else {
            return null;
        }
    }, data);
    return (result !== undefined && result !== null) ? result : defaultValue;
}

function pluck_key(array) {
    try {
        let results = [];
        let i = 0;
        $.each(array, function (key, value) {
            results[i] = key;
            i++;
        });
        return results;
    } catch (error) {
        return null;
    }
}

function debounce(func, delay) {
    let timeoutId;
    return function () {
        clearTimeout(timeoutId);
        timeoutId = setTimeout(func, delay);
    };
}

const convertDataExcel = (obj) => {
    const trimmedArray = [];

    for (const key in obj) {
        if (obj.hasOwnProperty(key)) {
            let count_excel = trimmedArray.length;

            // Check if the item is a child order based on the presence of certain properties
            if (typeof obj[key].weight === 'undefined' && count_excel > 0) {
                // Treat as a child order and add to the last main item
                if (!Array.isArray(trimmedArray[count_excel - 1].childOrders)) {
                    trimmedArray[count_excel - 1].childOrders = [];
                }
                trimmedArray[count_excel - 1].childOrders.push({
                    HAWB: obj[key].HAWB,
                    Tracking_Code: obj[key].Tracking_Code,
                });
            } else {
                // Treat as a main order and initialize childOrders with dimensions if they exist
                trimmedArray.push({
                    ...obj[key],
                    childOrders: [{
                        weight: obj[key].weight,
                        height: obj[key].height,
                        length: obj[key].length,
                        width: obj[key].width,
                    }],
                });
            }
        }
    }
    return trimmedArray;
};

async function getBase64FromFile(file) {
    return new Promise((resolve, reject) => {
        var reader = new FileReader();

        reader.onload = function (e) {
            resolve(e.target.result); // Trả về kết quả Base64
        };

        reader.onerror = function (error) {
            reject(error); // Nếu có lỗi xảy ra, trả về lỗi
        };

        reader.readAsDataURL(file);
    });
}

function generateUUID() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = Math.random() * 16 | 0,
            v = c === 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
}