let transfer_id = null,
    limit = 25,
    page = 1,
    _url = window.location.origin + "/transfer";
let editor,
    transferDropzone,
    transfer_images = [];
    transfer_shipment_codes = [];

$(document).ready(function () {
    $('input[name="transfer_daterange"]').daterangepicker(
        {
            opens: "left",
            startDate: moment().subtract(3, "months").startOf("month"),
            endDate: moment().endOf("month"),
            locale: {
                format: "DD/MM/YYYY",
                applyLabel: "Áp dụng",
                cancelLabel: "Hủy",
                customRangeLabel: "Tùy chỉnh",
                daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                monthNames: [
                    "Tháng 1",
                    "Tháng 2",
                    "Tháng 3",
                    "Tháng 4",
                    "Tháng 5",
                    "Tháng 6",
                    "Tháng 7",
                    "Tháng 8",
                    "Tháng 9",
                    "Tháng 10",
                    "Tháng 11",
                    "Tháng 12",
                ],
            },
            ranges: {
                "Tháng này": [
                    moment().startOf("month"),
                    moment().endOf("month"),
                ],
                "Tháng trước": [
                    moment().subtract(1, "month").startOf("month"),
                    moment().subtract(1, "month").endOf("month"),
                ],
                "3 tháng trước": [
                    moment().subtract(3, "month").startOf("month"),
                    moment().subtract(1, "month").endOf("month"),
                ],
                "6 tháng trước": [
                    moment().subtract(6, "month").startOf("month"),
                    moment().subtract(1, "month").endOf("month"),
                ],
                "Năm nay": [moment().startOf("year"), moment().endOf("year")],
                "Năm trước": [
                    moment().subtract(1, "year").startOf("year"),
                    moment().subtract(1, "year").endOf("year"),
                ],
            },
        },
        function (start, end, label) {
            page = 1;
            onGetTransferList();
        }
    );

    onGetTransferList();

    $(document).on("click", "#onCreateTransfer", function () {
        $("#modalTransfer").modal("show");
    });

    $(document).on("click", ".btn-edit-transfer", function () {
        transfer_id = $(this).data("transfer_id");
        $("#modalTransfer").modal("show");
    });
    
    $(document).on("click", "#agreeSaveTransfer", async function () {
        $(this).attr("disabled", true);
        try {
            let data = {
                transfer_id: transfer_id,
                transfer_content: editor.getData(),
                transfer_images: transferDropzone.files.map(
                    (file) => file.dataURL
                ),
                receiver_name: $('[name="receiver_name"]').val(),
                receiver_phone: $('[name="receiver_phone"]').val(),
                receiver_address: $('[name="receiver_address"]').val(),
                transfer_shipment_codes: transfer_shipment_codes,
            };

            const result = await sendRequest(`${_url}/update`, "POST", data);


            page = 1;
            onGetTransferList();

            $("#modalTransfer").modal("hide");
            showMessage(result.message);
        } catch (error) {
            if (error.status == 422) {
                const errors = Object.values(error.responseJSON.errors);
                showMessage({
                    text: errors[0][0],
                    icon: "warning",
                    title: "Cảnh báo!",
                });
            } else {
                showMessage(error.message);
            }
        }
        $(this).attr("disabled", false);
    });

    $(document).on("show.bs.modal", "#modalTransfer", async function () {
        $("#loading_show_transfer").addClass("d-block");
        $("#loading_show_transfer").removeClass("d-none");
        if (transfer_id) {
            await onEditTransfer();
        } else {
            transfer_shipment_codes = [
                {
                    shipment_code: ''
                }
            ];
            await onCreateTransfer();
        }
        loadHtmlShipmentCodes();
        $("#loading_show_transfer").removeClass("d-block");
        $("#loading_show_transfer").addClass("d-none");
    });

    $(document).on("hide.bs.modal", "#modalTransfer", function () {
        $("#contentModalTransfer").html("");
        transfer_id = null;
        transfer_images = [];
        transfer_shipment_codes = [];
        editor.destroy();
        transferDropzone.destroy();
    });

    $(document).on("click", ".btn-delete-transfer", function () {
        const id = $(this).data("transfer_id");
        Swal.fire({
            title: "Xác nhận xóa",
            text: "Bạn có chắc chắn muốn xóa khai hàng này không?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#3085d6",
            confirmButtonText: "Xóa",
            cancelButtonText: "Hủy",
        }).then(async (result) => {
            if (result.isConfirmed) {
                const result = await agreeDeleteTransfer(id);
                
                page = 1;
                onGetTransferList();
                showMessage(result.message);
            }
        });
    });

    $(document).on("click", ".btn-approve-transfer", function () {
        const id = $(this).data("transfer_id");
        Swal.fire({
            title: "Xác nhận xóa",
            text: "Bạn có chắc chắn muốn duyệt khai hàng này không?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#3085d6",
            confirmButtonText: "Xác nhận",
            cancelButtonText: "Hủy",
        }).then(async (result) => {
            if (result.isConfirmed) {
                const result = await agreeApproveTransfer(id);
                
                page = 1;
                onGetTransferList();
                showMessage(result.message);
            }
        });
    });


    $(document).on('click', '#add-input-shipment-code-btn', function () {
        transfer_shipment_codes.push({
            shipment_code: ''
        });
        loadHtmlShipmentCodes();
    });

    $(document).on('click', '.btn-delete-shipment-code', function () {
        const index = $(this).data('index');
        transfer_shipment_codes.splice(index, 1);
        loadHtmlShipmentCodes();
    });

    $(document).on('change', '[name^="transfer_shipment_codes."]', function () {
        const value = $(this).val();
        let input_name = $(this).attr('name');

        var parts = input_name.split('.');
        if (parts.length > 1) {
            input_name = input_name.replace('transfer_shipment_codes.', '');
        }
        transfer_shipment_codes = setData(transfer_shipment_codes, input_name, value);
    });
});

function loadHtmlShipmentCodes() {
    $('#formShipmentCode').html('');
    transfer_shipment_codes.forEach((item, index) => {
        $('#formShipmentCode').append(`
            <div class="col-12 mb-3">
                <div class="input-group mb-3">
                    <input type="text" class="form-control" placeholder="Nhập shipment code" name="transfer_shipment_codes.${index}.shipment_code"
                        value="${item.shipment_code}">
                    <button class="input-group-text btn btn-danger btn-delete-shipment-code" type="button" data-index="${index}">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        `);
    });
}

$(document).on("change", '[name="transfer_keywords"]', function () {
    
    page = 1;
    onGetTransferList();
});

$(document).on("click", ".pagination a", function (event) {
    event.preventDefault();
    page = $(this).attr("href").split("page=")[1];
    onGetTransferList();
});

function getFilters() {
    return {
        date_range: {
            start_date: $('input[name="transfer_daterange"]')
                .data("daterangepicker")
                .startDate.format("DD-MM-YYYY"),
            end_date: $('input[name="transfer_daterange"]')
                .data("daterangepicker")
                .endDate.format("DD-MM-YYYY"),
        },
        keywords: $('[name="transfer_keywords"]').val(),
    };
}

async function onGetTransferList() {
    $("#show_table_content").html("");
    $("#loading_show_table_content").addClass("d-block");
    $("#loading_show_table_content").removeClass("d-none");
    try {
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, getFilters())),
        };
        
        const result = await sendRequest(`${_url}/pagination`, "POST", data);

        if (result.status == 200) {
            $("#show_table_content").html(result.html);
        }

        $("#loading_show_table_content").removeClass("d-block");
        $("#loading_show_table_content").addClass("d-none");
    } catch (error) {
        $("#loading_show_table_content").removeClass("d-block");
        $("#loading_show_table_content").addClass("d-none");
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

async function onCreateTransfer() {
    try {
        const result = await sendRequest(`${_url}/create`, "POST", {});

        if (result.status == 200) {
            $("#contentModalTransfer").html(result.html);
        }
    } catch (error) {
        showMessage(error.message);
    }
}

async function onEditTransfer() {
    try {
        let data = {
            transfer_id: transfer_id,
        };

        const result = await sendRequest(`${_url}/edit`, "POST", data);

        await $("#contentModalTransfer").html(result.html);

        transfer_images = result.transfer_images;
        transfer_shipment_codes = result.transfer_shipment_codes;
    } catch (error) {
        showMessage(error.message);
    }
}

async function agreeDeleteTransfer(id) {
    try {
        const result = await sendRequest(`${_url}/delete`, "POST", {
            transfer_id: id,
        });
        return result;
    } catch (error) {
        showMessage(error.message);
    }
}

async function agreeApproveTransfer(id) {
    try {
        const result = await sendRequest(`${_url}/approve`, "POST", {
            transfer_id: id,
        });
        return result;
    } catch (error) {
        showMessage(error.message);
    }
}

async function showDetailTransfer(item) {
    let images = JSON.parse(item.transfer_images);
    let content = item.transfer_content;
    let receiver = {
        receiver_name: item.receiver_name,
        receiver_phone: item.receiver_phone,
        receiver_address: item.receiver_address,
    }
    let html = `
        <div class="p-2 row">
    `;

    $.each(images, function (index, image) {
        html += `
            <div class="col-md-3 mt-3">
                <a href="${window.location.origin}/${image}" target="_blank">
                    <img src="${window.location.origin}/${image}" class="img-fluid img-thumbnail" alt="image">
                </a>
            </div>
        `;
    });

    html += `
        <div class="text-start mb-6">
            <label class="fw-bold">Người nhận:</label>
            <p>${receiver.receiver_name}</p>
            <label class="fw-bold">Số điện thoại:</label>
            <p>${receiver.receiver_phone}</p>
            <label class="fw-bold">Địa chỉ:</label>
            <p>${receiver.receiver_address}</p>
        </div> <hr>
    `;

    html += `
            <div class="col-md-12 mt-3 text-start">
                ${content}
            </div>
        </div>
    `;

    let width = window.innerWidth <= 768 ? '95%' : '80%';
    Swal.fire({
        title: "Chi tiết khai hàng!",
        width: width,
        html: html,
        showCloseButton: true,
    });
}
