$(document).ready(async function () {
    editor.plugins.get("FileRepository").createUploadAdapter = (loader) => {
        return {
            upload: () => {
                return loader.file.then(
                    (file) =>
                        new Promise((resolve, reject) => {
                            const reader = new FileReader();
                            reader.readAsDataURL(file);
                            reader.onload = () =>
                                resolve({
                                    default: reader.result,
                                });
                            reader.onerror = (error) => reject(error);
                        })
                );
            },
        };
    };

    transferDropzone = await new Dropzone("#transfer-dropzone", {
        url: "/upload",
        autoProcessQueue: false,
        paramName: "file",
        clickable: true,
        maxFilesize: 10,
        addRemoveLinks: true,
        acceptedFiles: ".jpg,.jpeg,.png,.gif",
        dictDefaultMessage: "Tải hình ảnh ở đây",
    });

    if (transferDropzone && transfer_images.length > 0) {
        $.each(transfer_images, function (key, value) {
            let uuid = generateUUID();
            var mockFile = {
                name: value.name,
                size: value.size,
                dataURL: value.normal,
                upload: {
                    uuid: uuid
                },
            };
            transferDropzone.files.push(mockFile);
            transferDropzone.options.addedfile.call(transferDropzone, mockFile)
            transferDropzone.options.thumbnail.call(transferDropzone, mockFile, value.path)
            transferDropzone.emit('complete', mockFile);
        });
    }
});

ClassicEditor.create(document.querySelector("#editor"), {
    mediaEmbed: {
        previewsInData: true,
    },
})
    .then((newEditor) => {
        editor = newEditor;
        editor.setData(transfer_content);        
    })
    .catch((error) => {
        console.error(error);
    });
