$(document).ready(function () {
    editor.plugins.get("FileRepository").createUploadAdapter = (loader) => {
        return {
            upload: () => {
                return loader.file.then(
                    (file) =>
                        new Promise((resolve, reject) => {
                            const reader = new FileReader();
                            reader.readAsDataURL(file);
                            reader.onload = () =>
                                resolve({
                                    default: reader.result,
                                });
                            reader.onerror = (error) => reject(error);
                        })
                );
            },
        };
    };

    transferDropzone = new Dropzone("#transfer-dropzone", {
        url: "/upload",
        autoProcessQueue: false,
        paramName: "file",
        clickable: true,
        maxFilesize: 10,
        addRemoveLinks: true,
        acceptedFiles: ".jpg,.jpeg,.png,.gif",
        dictDefaultMessage: "Tải hình ảnh ở đây",
    });
});

ClassicEditor.create(document.querySelector("#editor"), {
    mediaEmbed: {
        previewsInData: true,
    },
})
    .then((newEditor) => {
        editor = newEditor;
        const template_transfer = $("#template_transfer").html();
        editor.setData(template_transfer);
    })
    .catch((error) => {
        console.error(error);
    });

    
