var limit = 50, page = 1, admin_ticket_id = null;
var admin_note_ticket_id = null;

$(document).ready(async function () {
    getTickets();

    $(document).on('click', '.btn-add-note-ticket', async function () {
        admin_note_ticket_id = $(this).data('ticket_id');
        $('#ticket_note').val($(this).data('ticket_note'));
        $('#modalAddNoteTicket').modal('show');
    });

    $(document).on('click', '#save_ticket_note', async function () {
        $(this).attr('disabled', true);
        try {
            let data = {
                ticket_id: admin_note_ticket_id,
                ticket_note: $('#ticket_note').val(),
                is_api: false,
            };

            const result = await sendRequest(`${window.location.origin}/tickets/update-note`, 'POST', data);

            getTickets(2);
            showMessage(result.message);
            $('#modalAddNoteTicket').modal('hide');
        } catch (error) {
            if (error.status == 422) {
                const errors = Object.values(error.responseJSON.errors);
                showMessage({
                    'title': 'Cảnh báo!',
                    'text': errors[0][0],
                    'icon': 'warning'
                });
            }else{
                showMessage(error.message);
            }
        }
        $(this).attr('disabled', false);
    });

    $(document).on('hidden.bs.modal', '#modalAddNoteTicket', function (e) {
        admin_note_ticket_id = null;
        $('#ticket_note').val('');
    });
});

async function getTickets(status = 0) {
    try {
        $('#form_tickets_list').html('');
        let data = {
            is_api: false,
            ticket_status: status,
            limit: limit,
            page: page,
        }
        let result = await sendRequest(`${window.location.origin}/tickets/list`, 'POST', data);
        if (result.status == 200) {
            await $('#form_tickets_list').html(result.html);
            if (admin_ticket_id) {
                $(`#active_ticket_${admin_ticket_id}`).addClass('read-chat active-user');
            }
            $('#total_tickets_pending').html(`${result.total_tickets_pending > 9 ? '9+' : result.total_tickets_pending}`);
            if (result.total_tickets_pending <= 0) {
                $('#total_tickets_pending').addClass('d-none');
            } else {
                $('#total_tickets_pending').removeClass('d-none');
            }
            $('#total_tickets_processing').html(`${result.total_tickets_processing > 9 ? '9+' : result.total_tickets_processing}`);
            if (result.total_tickets_processing <= 0) {
                $('#total_tickets_processing').addClass('d-none');
            } else {
                $('#total_tickets_processing').removeClass('d-none');
            }
        }
    } catch (error) {
        showMessage(error.message);
    }
}

async function selectedTicket(ticket) {
    admin_ticket_id = ticket;
    if (admin_ticket_id != null) {
        let width = window.innerWidth;
        if (width <= 991) {
            chatAppTarget.addClass('chatapp-slide');
            $wrapper.attr('data-navbar-style', 'collapsed');
            $('.hk-pg-wrapper').css('transition', '0s');
        }
        $('.chatapp-single-chat').html('');
        try {
            let data = {
                is_api: false,
                ticket_id: admin_ticket_id,
            }
            let result = await sendRequest(`${window.location.origin}/tickets/single-chat`, 'POST', data);
            if (result.status == 200) {
                await $('.chatapp-single-chat').html(result.html);
                $.each($('#form_tickets_list .list-group-item .media'), function (index, value) {
                    $(this).removeClass('read-chat active-user');
                });
                if (admin_ticket_id) {
                    $(`#active_ticket_${admin_ticket_id}`).addClass('read-chat active-user');
                }
                var demoScroll = document.querySelector('body #chat_body .simplebar-content-wrapper');
                setTimeout(() => {
                    demoScroll.scrollTo({ top: 100000, behavior: "smooth" });
                }, 500);
            }
        } catch (error) {
            showMessage(error.message);
        }
    }
}

$('body').on('click', '#on_send_message_ticket_answer', async function () {
    if (admin_ticket_id != null) {
        $(this).attr('disabled', true);
        try {
            let data = {
                is_api: false,
                is_answer: true,
                ticket_id: admin_ticket_id,
                ticket_message_content: $('[name="input_message_ticket_answer"]').val()
            }
            let result = await sendRequest(`${window.location.origin}/tickets/add-message`, 'POST', data);
            if (result.status == 200) {
                $('#single_chat_list').append(`
                    <li class="media sent">
                        <div class="media-body">
                            <div class="msg-box">
                                <div>
                                    <p>${result.ticket_message_content}</p>
                                    <span class="chat-time">${result.created_at}</span>
                                </div>
                            </div>
                        </div>
                    </li>
                `);
                $(`#user_last_chat_${admin_ticket_id}`).html(`Tôi: ${result.ticket_message_content}`);
                $('[name="input_message_ticket_answer"]').val('');
                var demoScroll = document.querySelector('#chat_body .simplebar-content-wrapper');
                setTimeout(() => {
                    demoScroll.scrollTo({ top: 100000, behavior: "smooth" });
                }, 500);
            } else {
                showMessage(result.message);
            }
            $(this).attr('disabled', false);
        } catch (error) {
            if (error.status != 422) {
                showMessage(error.message);
            }
            $(this).attr('disabled', false);
        }
    }
});

$('body').on('keydown', '[name="input_message_ticket_answer"]', async function (e) {
    if (e.keyCode === 13 && $(this).is(':focus')) {
        e.preventDefault();
        $('#on_send_message_ticket_answer').click();
    }
});

async function onChangeTicketStatus(ticket_id, status, status_current) {
    try {
        let data = {
            is_api: false,
            ticket_id: ticket_id,
            ticket_status: status
        }
        let result = await sendRequest(`${window.location.origin}/tickets/update-status`, 'POST', data);
        if (result.status == 200) {
            await getTickets(status_current);
        }
        showMessage(result.message);
    } catch (error) {
        showMessage(error);
    }
}