let limit = 50;
let page = 1;
let isBillCode = true;

$(document).ready(function () {
    setIsBillCode(false);
});

function getFilters() {
    return {
        keywords: $('#keywords').val()
    }
}

function setIsBillCode(value) {
    isBillCode = value == true ? true : false;
    fetchData()
}

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        fetchData();
    }
})



$(document).ready(function () {
    fetchData()
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});

function fetchData(_url = null, _page = null, _limit = null, filters = null) {
    if (!_url) {
        _url = window.location.origin + '/sms-manager/history-sms'
    }

    let _data = {
        bill_code: isBillCode ? isBillCode : null,
        paginate: {
            limit: _limit === null ? limit : _limit,
            page: _page === null ? page : _page,
        },
        filters: filters === null ? getFilters() : filters,
    }

    let id_html = isBillCode ? 'content_bill_used' : 'content_history'

    ajaxPostHTML(_url, _data, id_html)
}

