async function getAreasForWorld(country_id = null, state_id = null, key_element_country_id, key_element_state_id, key_element_city_id, is_name = true) {
    
    $(is_name ? `[name="${key_element_country_id}"]` : `#${key_element_country_id}`).find('option').not('[value=""]').remove();
    if (!state_id) {
        $(is_name ? `[name="${key_element_state_id}"]` : `#${key_element_state_id}`).find('option').not('[value=""]').remove();
        $(is_name ? `[name="${key_element_state_id}"]` : `#${key_element_state_id}`).attr("disabled", true);
    }
    $(is_name ? `[name="${key_element_city_id}"]` : `#${key_element_city_id}`).find('option').not('[value=""]').remove();
    $(is_name ? `[name="${key_element_city_id}"]` : `#${key_element_city_id}`).attr("disabled", true);
    try {
        let data = {
            country_id: country_id,
            state_id: state_id,
        }
        const result = await sendRequest(`${window.location.origin}/areas`, 'POST', data);
        if (result.status == 200) {
            $.each(result.areas.countries, function (key_country, country) {
                let option = $('<option>', {
                    value: country.country_id,
                    text: `${country.country_name} - ${country.country_code}`
                });
                if (country.country_id == country_id) {
                    option.attr('selected', 'selected');
                }
                $(is_name ? `[name="${key_element_country_id}"]` : `#${key_element_country_id}`).append(option);
            });

            if (result.areas.states && result.areas.states.length < 1) {
                if ($('#receiver_state_id').hasClass('required')) {
                    $('#receiver_state_id').removeClass('required');
                    // $('#receiver_state_noti').html('*Quốc gia này không có State');
                }
            } else {
                if (!$('#receiver_state_id').hasClass('required')) {
                    $('#receiver_state_id').addClass('required');
                    $('#receiver_state_noti').html('');
                }
            }
            $('#receiver_state_id').html('');


            $.each(result.areas.states, function (key, state) {
                let option = $('<option>', {
                    value: state.state_id,
                    text: `${state.state_name} - ${state.state_code}`
                });
                if (state.state_id == state_id) {
                    option.attr('selected', 'selected');
                }
                $(is_name ? `[name="${key_element_state_id}"]` : `#${key_element_state_id}`).append(option);
            });

            // Dành cho text input area
            let empty_opt = $('<option>', {
                value: '',
                text: 'Không tìm thấy khu vực'
            });
            if (state_id == "" || state_id == null) {
                empty_opt.attr('selected', 'selected');
                if (document.getElementById('receiver_state_name')) {
                    $('#receiver_state_name').attr('disabled', false);
                }
            } else {
                if (document.getElementById('receiver_state_name')) {
                    $('#receiver_state_name').attr('disabled', true);
                    $('#receiver_state_name').val('');
                }
            }
            $(is_name ? `[name="${key_element_state_id}"]` : `#${key_element_state_id}`).append(empty_opt);
            if (state_id) {
                let state_filtered = result.areas.states.filter(state => state.state_id == state_id);
                if (state_filtered.length > 0) {
                    if (state_filtered[0].state_post_code != null && state_filtered[0].state_post_code != '') {
                        $('[name="receiver_postal_code"]').val(state_filtered[0].state_post_code);
                    }
                }
            }
            if (result.areas.cities && result.areas.cities.length < 1) {
                if ($(`#${key_element_city_id}`).hasClass('required')) {
                    $(`#${key_element_city_id}`).removeClass('required');
                    // $('#receiver_city_noti').html('Đất nước này khôn g có thành phố');

                }
            } else {
                if (!$(`#${key_element_city_id}`).hasClass('required')) {
                    $(`#${key_element_city_id}`).addClass('required');
                    $('#receiver_city_noti').html('');
                }
            }
            $(`#${key_element_city_id}`).html('');
            $.each(result.areas.cities, function (key, city) {
                let option = $('<option>', {
                    value: city.city_id,
                    text: `${city.city_name}`
                });
                if (city.city_id == $(is_name ? `[name="${key_element_city_id}"]` : `#${key_element_city_id}`).val()) {
                    option.attr('selected', 'selected');
                }
                $(is_name ? `[name="${key_element_city_id}"]` : `#${key_element_city_id}`).append(option);
            });
        } else {
            showMessage(result.message);
        }
        $(is_name ? `[name="${key_element_state_id}"]` : `#${key_element_state_id}`).attr("disabled", false);
        $(is_name ? `[name="${key_element_city_id}"]` : `#${key_element_city_id}`).attr("disabled", false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(is_name ? `[name="${key_element_state_id}"]` : `#${key_element_state_id}`).attr("disabled", false);
        $(is_name ? `[name="${key_element_city_id}"]` : `#${key_element_city_id}`).attr("disabled", false);
    }
}


function onNextAccordion(currentId, nextId) {
    const currentForm = document.querySelector(`#${currentId} form`);
    if (currentForm.checkValidity()) {
        const currentAccordion = document.getElementById(currentId);
        const nextAccordion = nextId ? document.getElementById(nextId) : null;

        // Đóng accordion hiện tại
        const bsCollapse = new bootstrap.Collapse(currentAccordion, { toggle: false });
        bsCollapse.hide();

        // Mở accordion kế tiếp nếu có
        if (nextAccordion) {
            const nextBsCollapse = new bootstrap.Collapse(nextAccordion, { toggle: false });
            nextBsCollapse.show();
        }
    } else {
        currentForm.reportValidity(); // Hiển thị thông báo lỗi nếu có
    }
}

$("#form-sender, #form-receiver, #form-service, #form-info").on("submit", function (event) {
    event.preventDefault(); // Ngăn tải lại trang
});


function onSetState(id, name, code) {
    $('#receiver_state_id').val(id);
    $('#receiver_state_name').val(name);
    onShowModal('#stateModal', false);
}
function onSetcityWorld(id, name, code) {
    $('#receiver_city_id').val(id);
    $('#receiver_city_name').val(name);
    onShowModal('#cityWorldModal', false);
}