let limit = 50, page = 1, _url = window.location.origin + '/shipments';

$(document).ready(function () {
    $(".select2").select2();

    $('input[name="shipment_daterange"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(1, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        autoUpdateInput: false,
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
    });

    // Khi chọn ngày, cập nhật input
    $('input[name="shipment_daterange"]').on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('DD/MM/YYYY'));
        onGetDataShipments();
    });

    // Khi bấm "Hủy", xóa giá trị input
    $('input[name="shipment_daterange"]').on('cancel.daterangepicker', function (ev, picker) {
        $(this).val('');
        onGetDataShipments();
    });

    onGetDataShipments();

    let inputElement = document.querySelector('input[name="shipment_daterange"]').value;
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];

    onGetDataShipments();
});

function getFilters() {
    const startDate = $('input[name="shipment_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY');
    const endDate = $('input[name="shipment_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY');
    const date_range = $('input[name="shipment_daterange"]').val() == '' ? false : true;

    return {
        date_range: {
            start_date: date_range ? startDate : null,
            end_date: date_range ? endDate : null,
        },
        shipment_branch_id: $('[name="shipment_branch_id"]').val(),
        shipment_service_id: $('[name="shipment_service_id"]').val(),
        shipment_status: $('[name="shipment_status"]').val(),
        shipment_payment_status: $('[name="shipment_payment_status"]').val(),
        checked_payment_status: $('[name="checked_payment_status"]').val(),
        keywords: $('[name="shipment_keywords"]').val(),
        filter_by: $('[name="filter_by"]').val(),
        active_flg: $('[name="shipment_active_flg"]').val(),
    }
}

$('[name="shipment_daterange"]').on('apply.daterangepicker', function (ev, picker) {
    page = 1;
    onGetDataShipments();
});

$('[name="shipment_branch_id"], [name="checked_payment_status"], [name="shipment_service_id"], [name="shipment_status"], [name="filter_by"], [name="shipment_payment_status"], [name="shipment_active_flg"]').on('change', function () {
    page = 1;
    onGetDataShipments();
});

let typingTimer = null;
let previousValue = $('[name="shipment_keywords"]').val();
$('[name="shipment_keywords"]').on('keyup', function (event) {
    clearTimeout(typingTimer);
    let currentValue = $(this).val();
    if (currentValue !== previousValue || event.key === 'Enter') {
        typingTimer = setTimeout(onGetDataShipments, 500);
        previousValue = currentValue;
    }
});

async function onGetDataShipments() {
    $('#show_table_content').html('');
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    try {
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, getFilters())),
        };

        const result = await sendRequest(`${_url}/pagination`, 'POST', data);
        if (result.status == 200) {
            $('#show_table_content').html(result.html);
        }
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
    } catch (error) {
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function showShipmentDetail(key) {
    const icon = $(`#btn_shipment_${key} span i`).attr('class');
    if (icon == "fa fa-plus") {
        $(`#btn_shipment_${key} span i`).removeClass('fa-plus');
        $(`#btn_shipment_${key} span i`).addClass('fa-minus');
        $(`#btn_shipment_${key}`).removeClass('btn-flush-success');
        $(`#btn_shipment_${key}`).addClass('btn-flush-danger');
    } else {
        $(`#btn_shipment_${key} span i`).removeClass('fa-minus');
        $(`#btn_shipment_${key} span i`).addClass('fa-plus');
        $(`#btn_shipment_${key}`).removeClass('btn-flush-danger');
        $(`#btn_shipment_${key}`).addClass('btn-flush-success');
    }
}

function onDeleteShipment(shipment_code) {
    console.log(shipment_code);

    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa lô hàng này không?',
        icon: 'question',
        type: 'agreeDeleteShipment',
        data: {
            is_api: false,
            shipment_code: shipment_code,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteShipment(data) {
    try {
        const result = await sendRequest(`${_url}/delete`, 'POST', data);
        if (result.status == 200) {
            onGetDataShipments();
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

async function onExportExcel() {
    let data = {
        is_api: false,
        export_excel: true,
        filters: JSON.stringify(Object.assign({}, getFilters())),
    };
    let url = `${_url}/pagination`;
    const file_name = 'ListShipment.xlsx';
    fetchExportExcel(url, data, '#btn_excel_sm', file_name)
}

$('#getNumbersBtn').on('click', function () {

});

async function UploadLabel() {
    try {
        let numbers = getNumbersFromTextarea();
        const url = window.location.origin + '/shipments/upload-label';
        const data = {
            numbers: numbers
        }
        let result = await ajaxContants2(url, 'POST', data);
        if (result.status == 200) {
            onGetDataShipments();
            onShowModal('upload_label', false);
        }
        showMessage(result.message);
    } catch (error) {
        showMessage();
    }
}

// Hàm lấy từng số từ textarea
function getNumbersFromTextarea() {
    let text = $('#numberList').val();  // Lấy nội dung từ textarea
    let numbers = text.split('\n');  // Tách từng dòng
    numbers = numbers.map(num => num.trim()).filter(num => num !== "");  // Xóa khoảng trắng và bỏ dòng trống
    return numbers;
}