const internalContainer = $('#declare-internal-goods-container');
const declareInternalGoodsBtn = $('#declare-internal-goods-btn');


const externalContainer = $('#declare-external-goods-container');
const declareExternalGoodsBtn = $('#declare-external-goods-btn');

$(document).ready(function() {
    // internal surcharge
    onCloneInternalSurchargeInput();
    onUpdateInternalSurcharge();
    initDeleteInternalSurchargeEvents();

    // external surcharge
    onCloneExternalSurchargeInput();
    onUpdateExternalSurcharge();
    initDeleteExternalSurchargeEvents();

});


function onCloneExternalSurchargeInput() {
    declareExternalGoodsBtn.on('click', () => {
        const clone = $(externalSurchargeTemplateHtml);
        externalContainer.append(clone);
        clone.find('.surcharge-selector').select2();
        clone.find('[data-feather]').each(function() {
            feather.replace();
        });
        clone.find('.btn-outline-danger').on('click', function() {
            $(this).closest('.external-surcharge-row').remove();
        });
    });
}

function onCloneInternalSurchargeInput() {
    declareInternalGoodsBtn.on('click', () => {
        const clone = $(internalSurchargeTemplateHtml);
        internalContainer.append(clone);
        clone.find('[data-feather]').each(function() {
            feather.replace();
        });
        clone.find('.btn-outline-danger').on('click', function() {
            $(this).closest('.surcharge-row').remove();
        });
    });
}

function onUpdateInternalSurcharge() {
    $('#update-surcharge-btn').on('click', function() {
        let package_id = $(this).data('package-id');
        updateSurcharge(package_id);
    });
}

function onUpdateExternalSurcharge() {
    $('#update-external-surcharge-btn').on('click', function() {
        let package_id = $(this).data('package-id');
        updateExternalSurcharge(package_id);
    });
}

async function updateExternalSurcharge(package_id) {
    $('#update-external-surcharge-btn').prop('disabled', true);
    let _url = window.location.origin + `/debit/fwd/imported-goods/detail/update-external-surcharge/${package_id}`;
    try {
        let res = await ajaxContants2(_url, 'POST', JSON.stringify(externalSurchargeData()), false);
        if (res.status == 200) {
            $('#update-external-surcharge-btn').prop('disabled', false);
            showMessage({
                icon: 'success',
                title: 'Thông báo',
                text: res.message
            });
        } else {
            $('#update-external-surcharge-btn').prop('disabled', false);
            console.log(res.error);
            showMessage({
                icon: 'error',
                title: 'Thất bại',
                text: res.message
            });
        }
        
    } catch (error) {
        showMessage({
            icon: 'error',
            title: 'Thất bại',
            text: ' '
        });
        console.log(error);
        
    }
}

async function updateSurcharge(package_id) {
    $('#update-surcharge-btn').prop('disabled', true);
    let _url = window.location.origin + `/debit/fwd/imported-goods/detail/update-internal-surcharge/${package_id}`;

    try {
        let res = await ajaxContants2(_url, 'POST', JSON.stringify(internalSurchargeData()), false);

        if (res.status == 200) {
            $('#update-surcharge-btn').prop('disabled', false);
            showMessage({
                icon: 'success',
                title: 'Thông báo',
                text: res.message
            });
        } else {
            $('#update-surcharge-btn').prop('disabled', false);
            console.log(res.error);
            showMessage({
                icon: 'error',
                title: 'Thất bại',
                text: res.message
            });
        }
    } catch (error) {
        $('#update-surcharge-btn').prop('disabled', false);
        showMessage({
            icon: 'error',
            title: 'Thất bại',
            text: ' '
        });
    }
}

function internalSurchargeData() {
    let data = {
        surcharge: []
    };

    $('.surcharge-row').each(function() {
        let surcharge_id = $(this).find('.surcharge-selector').val();
        let surcharge_amount = $(this).find('#count').val();
        let surcharge_goods_price = $(this).find('.surcharge-selector').find(':selected').attr(
            'data-surcharge-price');

            data.surcharge.push({
            surcharge_id: surcharge_id,
            surcharge_amount: surcharge_amount,
            surcharge_price: surcharge_goods_price
        });
    });
    return data;
}

function externalSurchargeData() {
    let data = {
        external_surcharge: []
    };
    $('.external-surcharge-row').each(function() {
        let external_surcharge_name = $(this).find('#external-surcharge-name').val();
        let external_surcharge_quantity = $(this).find('#external-surcharge-quantity').val();
        let external_surcharge_unit_price = $(this).find('#external-surcharge-unit-price').val();
        data.external_surcharge.push({
            external_surcharge_name: external_surcharge_name,
            external_surcharge_quantity: external_surcharge_quantity,
            external_surcharge_unit_price: external_surcharge_unit_price
        });
    });
    return data;

}
function initDeleteInternalSurchargeEvents() {
    $('.btn-outline-danger').on('click', function() {
        $(this).closest('.surcharge-row').remove();
    });
}

function initDeleteExternalSurchargeEvents() {
    $('.btn-outline-danger').on('click', function() {
        $(this).closest('.external-surcharge-row').remove();
    });
}
